/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.hibernate.search.engine.backend.index.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.index.DocumentRefreshStrategy;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoSearchScopeDelegateImpl;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoWorkPlanImpl;
import org.hibernate.search.mapper.pojo.search.spi.PojoSearchScopeDelegate;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.session.spi.PojoSearchSessionDelegate;
import org.hibernate.search.mapper.pojo.work.impl.PojoSessionWorkExecutorImpl;
import org.hibernate.search.mapper.pojo.work.spi.PojoSessionWorkExecutor;
import org.hibernate.search.mapper.pojo.work.spi.PojoWorkPlan;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class PojoSearchSessionDelegateImpl
implements PojoSearchSessionDelegate {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoIndexedTypeManagerContainer indexedTypeManagers;
    private final PojoContainedTypeManagerContainer containedTypeManagers;
    private final AbstractPojoSessionContextImplementor sessionContext;

    PojoSearchSessionDelegateImpl(PojoIndexedTypeManagerContainer indexedTypeManagers, PojoContainedTypeManagerContainer containedTypeManagers, AbstractPojoSessionContextImplementor sessionContext) {
        this.indexedTypeManagers = indexedTypeManagers;
        this.containedTypeManagers = containedTypeManagers;
        this.sessionContext = sessionContext;
    }

    @Override
    public <E, E2> PojoSearchScopeDelegate<E, E2> createPojoSearchScope(Collection<? extends Class<? extends E>> targetedTypes) {
        if (targetedTypes.isEmpty()) {
            throw log.cannotSearchOnEmptyTarget();
        }
        LinkedHashSet targetedTypeManagers = new LinkedHashSet();
        for (Class<E> clazz : targetedTypes) {
            targetedTypeManagers.addAll((Collection)this.indexedTypeManagers.getAllBySuperClass(clazz).orElseThrow(() -> log.notIndexedType(targetedType)));
        }
        return new PojoSearchScopeDelegateImpl(this.indexedTypeManagers, targetedTypeManagers, this.sessionContext);
    }

    @Override
    public PojoWorkPlan createWorkPlan(DocumentCommitStrategy commitStrategy, DocumentRefreshStrategy refreshStrategy) {
        return new PojoWorkPlanImpl(this.indexedTypeManagers, this.containedTypeManagers, this.sessionContext, commitStrategy, refreshStrategy);
    }

    @Override
    public PojoSessionWorkExecutor createSessionWorkExecutor(DocumentCommitStrategy commitStrategy) {
        return new PojoSessionWorkExecutorImpl(this.indexedTypeManagers, this.sessionContext, commitStrategy);
    }
}

