/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.path.binding.impl;

import org.hibernate.search.mapper.pojo.extractor.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.binding.impl.PojoModelPathWalker;

public final class PojoModelPathBinder {
    private PojoModelPathBinder() {
    }

    public static <T, P, V> V bind(T typeNode, PojoModelPathValueNode unboundModelPath, PojoModelPathWalker<T, P, V> walker) {
        return PojoModelPathBinder.applyPath(typeNode, unboundModelPath, walker);
    }

    private static <T, P, V> V applyPath(T rootNode, PojoModelPathValueNode unboundPathValueNode, PojoModelPathWalker<T, P, V> walker) {
        P propertyNode = PojoModelPathBinder.applyPath(rootNode, unboundPathValueNode.getParent(), walker);
        ContainerExtractorPath extractorPath = unboundPathValueNode.getExtractorPath();
        return walker.value(propertyNode, extractorPath);
    }

    private static <T, P, V> P applyPath(T rootNode, PojoModelPathPropertyNode unboundPathPropertyNode, PojoModelPathWalker<T, P, V> walker) {
        T typeNode;
        PojoModelPathValueNode unboundPathParentNode = unboundPathPropertyNode.getParent();
        if (unboundPathParentNode != null) {
            V valueNode = PojoModelPathBinder.applyPath(rootNode, unboundPathParentNode, walker);
            typeNode = walker.type(valueNode);
        } else {
            typeNode = rootNode;
        }
        String propertyName = unboundPathPropertyNode.getPropertyName();
        return walker.property(typeNode, propertyName);
    }
}

