/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.processing.impl;

import java.util.Collection;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.document.IndexObjectFieldReference;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.mapper.pojo.bridge.TypeBridge;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessor;
import org.hibernate.search.mapper.pojo.processing.impl.PojoIndexingProcessorPropertyNode;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.ToStringTreeBuilder;

public class PojoIndexingProcessorTypeNode<T>
extends PojoIndexingProcessor<T> {
    private final Iterable<IndexObjectFieldReference> parentIndexObjectReferences;
    private final Collection<BeanHolder<? extends TypeBridge>> bridgeHolders;
    private final Collection<PojoIndexingProcessorPropertyNode<? super T, ?>> propertyNodes;

    public PojoIndexingProcessorTypeNode(Iterable<IndexObjectFieldReference> parentIndexObjectReferences, Collection<BeanHolder<? extends TypeBridge>> bridgeHolders, Collection<PojoIndexingProcessorPropertyNode<? super T, ?>> propertyNodes) {
        this.parentIndexObjectReferences = parentIndexObjectReferences;
        this.bridgeHolders = bridgeHolders;
        this.propertyNodes = propertyNodes;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(holder -> ((TypeBridge)holder.get()).close(), this.bridgeHolders);
            closer.pushAll(BeanHolder::close, this.bridgeHolders);
            closer.pushAll(PojoIndexingProcessor::close, this.propertyNodes);
        }
    }

    public void appendTo(ToStringTreeBuilder builder) {
        builder.attribute("class", (Object)this.getClass().getSimpleName());
        builder.attribute("parentIndexObjectReferences", this.parentIndexObjectReferences);
        builder.startList("bridges");
        for (BeanHolder<? extends TypeBridge> beanHolder : this.bridgeHolders) {
            builder.value(beanHolder.get());
        }
        builder.endList();
        builder.startList("propertyNodes");
        for (PojoIndexingProcessorPropertyNode pojoIndexingProcessorPropertyNode : this.propertyNodes) {
            builder.value((Object)pojoIndexingProcessorPropertyNode);
        }
        builder.endList();
    }

    @Override
    public final void process(DocumentElement target, T source, AbstractPojoSessionContextImplementor sessionContext) {
        if (source == null) {
            return;
        }
        DocumentElement parentObject = target;
        for (IndexObjectFieldReference indexObjectFieldReference : this.parentIndexObjectReferences) {
            parentObject = parentObject.addObject(indexObjectFieldReference);
        }
        for (BeanHolder beanHolder : this.bridgeHolders) {
            ((TypeBridge)beanHolder.get()).write(parentObject, source, sessionContext.getTypeBridgeWriteContext());
        }
        for (PojoIndexingProcessorPropertyNode pojoIndexingProcessorPropertyNode : this.propertyNodes) {
            pojoIndexingProcessorPropertyNode.process(parentObject, source, sessionContext);
        }
    }
}

