/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.util.impl;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Optional;
import org.hibernate.search.util.common.AssertionFailure;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Class<?> getRawType(Type type) {
        if (type instanceof TypeVariable) {
            Type[] upperBounds = ((TypeVariable)type).getBounds();
            return ReflectionUtils.getRawType(upperBounds[0]);
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return ReflectionUtils.getRawType(upperBounds[0]);
        }
        if (type instanceof ParameterizedType) {
            return ReflectionUtils.getRawType(((ParameterizedType)type).getRawType());
        }
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof GenericArrayType) {
            Class<?> rawElementType = ReflectionUtils.getRawType(((GenericArrayType)type).getGenericComponentType());
            return ReflectionUtils.getArrayClass(rawElementType);
        }
        throw new AssertionFailure("Unexpected java.lang.reflect.Type type: " + type.getClass());
    }

    public static Optional<Type> getArrayElementType(Type type) {
        if (type instanceof TypeVariable) {
            Type[] upperBounds = ((TypeVariable)type).getBounds();
            return ReflectionUtils.getArrayElementType(upperBounds[0]);
        }
        if (type instanceof WildcardType) {
            Type[] upperBounds = ((WildcardType)type).getUpperBounds();
            return ReflectionUtils.getArrayElementType(upperBounds[0]);
        }
        if (type instanceof ParameterizedType) {
            return Optional.empty();
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return Optional.ofNullable(clazz.getComponentType());
        }
        if (type instanceof GenericArrayType) {
            return Optional.of(((GenericArrayType)type).getGenericComponentType());
        }
        throw new AssertionFailure("Unexpected java.lang.reflect.Type type: " + type.getClass());
    }

    private static Class<?> getArrayClass(Class<?> rawElementType) {
        return Array.newInstance(rawElementType, 0).getClass();
    }
}

