/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.work.impl;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.index.DocumentCommitStrategy;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoIndexedTypeManagerContainer;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoTypeDocumentWorkExecutor;
import org.hibernate.search.mapper.pojo.model.spi.PojoRuntimeIntrospector;
import org.hibernate.search.mapper.pojo.session.context.spi.AbstractPojoSessionContextImplementor;
import org.hibernate.search.mapper.pojo.work.spi.PojoSessionWorkExecutor;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class PojoSessionWorkExecutorImpl
implements PojoSessionWorkExecutor {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoIndexedTypeManagerContainer indexedTypeManagers;
    private final AbstractPojoSessionContextImplementor sessionContext;
    private final PojoRuntimeIntrospector introspector;
    private final DocumentCommitStrategy commitStrategy;
    private final Map<Class<?>, PojoTypeDocumentWorkExecutor<?, ?, ?>> typeExecutors = new HashMap();

    public PojoSessionWorkExecutorImpl(PojoIndexedTypeManagerContainer indexedTypeManagers, AbstractPojoSessionContextImplementor sessionContext, DocumentCommitStrategy commitStrategy) {
        this.indexedTypeManagers = indexedTypeManagers;
        this.sessionContext = sessionContext;
        this.introspector = sessionContext.getRuntimeIntrospector();
        this.commitStrategy = commitStrategy;
    }

    @Override
    public CompletableFuture<?> add(Object entity) {
        return this.add(null, entity);
    }

    @Override
    public CompletableFuture<?> add(Object id, Object entity) {
        Class<Object> clazz = this.introspector.getClass(entity);
        PojoTypeDocumentWorkExecutor<?, ?, ?> typeExecutor = this.typeExecutors.get(clazz);
        if (typeExecutor == null) {
            typeExecutor = this.createTypeDocumentExecutor(clazz);
            this.typeExecutors.put(clazz, typeExecutor);
        }
        return typeExecutor.add(id, entity);
    }

    private PojoTypeDocumentWorkExecutor<?, ?, ?> createTypeDocumentExecutor(Class<?> clazz) {
        Optional<PojoIndexedTypeManager<?, ?, ?>> exactClass = this.indexedTypeManagers.getByExactClass(clazz);
        if (!exactClass.isPresent()) {
            throw log.notDirectlyIndexedType(clazz);
        }
        return exactClass.get().createDocumentWorkExecutor(this.sessionContext, this.commitStrategy);
    }
}

