/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.scope.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.engine.backend.scope.IndexScopeExtension;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.session.spi.DetachedBackendSessionContext;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScope;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScopeBuilder;
import org.hibernate.search.engine.search.aggregation.dsl.SearchAggregationFactory;
import org.hibernate.search.engine.search.highlighter.dsl.SearchHighlighterFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.projection.dsl.SearchProjectionFactory;
import org.hibernate.search.engine.search.query.dsl.SearchQuerySelectStep;
import org.hibernate.search.engine.search.sort.dsl.SearchSortFactory;
import org.hibernate.search.mapper.pojo.loading.spi.PojoSelectionLoadingContextBuilder;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoDefaultMassIndexer;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexer;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.schema.management.impl.PojoScopeSchemaManagerImpl;
import org.hibernate.search.mapper.pojo.schema.management.spi.PojoScopeSchemaManager;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeIndexedTypeContext;
import org.hibernate.search.mapper.pojo.scope.impl.PojoScopeTypeContextProvider;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeDelegate;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeMappingContext;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeSessionContext;
import org.hibernate.search.mapper.pojo.scope.spi.PojoScopeTypeExtendedContextProvider;
import org.hibernate.search.mapper.pojo.search.loading.impl.PojoSearchLoadingContextBuilder;
import org.hibernate.search.mapper.pojo.work.impl.PojoScopeWorkspaceImpl;
import org.hibernate.search.mapper.pojo.work.spi.PojoScopeWorkspace;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class PojoScopeDelegateImpl<R extends EntityReference, E, C>
implements PojoScopeDelegate<R, E, C> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoScopeMappingContext mappingContext;
    private final PojoScopeTypeContextProvider indexedTypeContextProvider;
    private final Set<? extends PojoScopeIndexedTypeContext<?, ? extends E>> targetedTypeContexts;
    private final Set<C> targetedTypeExtendedContexts;
    private MappedIndexScope<R, E> delegate;

    public static <R extends EntityReference, E, C> PojoScopeDelegate<R, E, C> create(PojoScopeMappingContext mappingContext, PojoScopeTypeContextProvider typeContextProvider, Collection<? extends PojoRawTypeIdentifier<? extends E>> targetedTypes, PojoScopeTypeExtendedContextProvider<E, C> indexedTypeExtendedContextProvider) {
        if (targetedTypes.isEmpty()) {
            throw log.invalidEmptyTargetForScope();
        }
        LinkedHashSet targetedTypeContexts = new LinkedHashSet();
        LinkedHashSet nonIndexedTypes = new LinkedHashSet();
        for (PojoRawTypeIdentifier<E> pojoRawTypeIdentifier : targetedTypes) {
            Optional<Set<PojoScopeIndexedTypeContext<?, E>>> targetedTypeManagersForType = typeContextProvider.allIndexedForSuperType(pojoRawTypeIdentifier);
            if (targetedTypeManagersForType.isPresent()) {
                targetedTypeContexts.addAll(targetedTypeManagersForType.get());
                continue;
            }
            nonIndexedTypes.add(pojoRawTypeIdentifier);
        }
        if (!nonIndexedTypes.isEmpty()) {
            throw log.invalidScopeTarget(nonIndexedTypes, typeContextProvider.allIndexedSuperTypes());
        }
        Set targetedTypeExtendedContexts = targetedTypeContexts.stream().map(PojoMassIndexingIndexedTypeContext::typeIdentifier).map(indexedTypeExtendedContextProvider::forExactType).collect(Collectors.toCollection(LinkedHashSet::new));
        return new PojoScopeDelegateImpl<R, E, C>(mappingContext, typeContextProvider, targetedTypeContexts, targetedTypeExtendedContexts);
    }

    private PojoScopeDelegateImpl(PojoScopeMappingContext mappingContext, PojoScopeTypeContextProvider indexedTypeContextProvider, Set<? extends PojoScopeIndexedTypeContext<?, ? extends E>> targetedTypeContexts, Set<C> targetedTypeExtendedContexts) {
        this.mappingContext = mappingContext;
        this.indexedTypeContextProvider = indexedTypeContextProvider;
        this.targetedTypeContexts = targetedTypeContexts;
        this.targetedTypeExtendedContexts = Collections.unmodifiableSet(targetedTypeExtendedContexts);
    }

    @Override
    public Set<C> includedIndexedTypes() {
        return this.targetedTypeExtendedContexts;
    }

    @Override
    public <LOS> SearchQuerySelectStep<?, R, E, LOS, SearchProjectionFactory<R, E>, ?> search(PojoScopeSessionContext sessionContext, PojoSelectionLoadingContextBuilder<LOS> loadingContextBuilder) {
        LinkedHashMap targetTypesByEntityName = new LinkedHashMap();
        for (PojoScopeIndexedTypeContext<?, E> type : this.targetedTypeContexts) {
            targetTypesByEntityName.put(type.entityName(), type);
        }
        return this.getIndexScope().search((BackendSessionContext)sessionContext, new PojoSearchLoadingContextBuilder(targetTypesByEntityName, sessionContext.mappingContext().entityReferenceFactoryDelegate(), sessionContext, loadingContextBuilder));
    }

    @Override
    public SearchPredicateFactory predicate() {
        return this.getIndexScope().predicate();
    }

    @Override
    public SearchSortFactory sort() {
        return this.getIndexScope().sort();
    }

    @Override
    public SearchProjectionFactory<R, E> projection() {
        return this.getIndexScope().projection();
    }

    @Override
    public SearchAggregationFactory aggregation() {
        return this.getIndexScope().aggregation();
    }

    @Override
    public SearchHighlighterFactory highlighter() {
        return this.getIndexScope().highlighter();
    }

    @Override
    @Deprecated
    public PojoScopeWorkspace workspace(DetachedBackendSessionContext sessionContext) {
        return this.workspace(sessionContext.tenantIdentifier());
    }

    @Override
    public PojoScopeWorkspace workspace(String tenantId) {
        return new PojoScopeWorkspaceImpl(this.mappingContext, this.targetedTypeContexts, CollectionHelper.asSetIgnoreNull((Object[])new String[]{tenantId}));
    }

    @Override
    public PojoScopeWorkspace workspace(Set<String> tenantIds) {
        return new PojoScopeWorkspaceImpl(this.mappingContext, this.targetedTypeContexts, tenantIds);
    }

    @Override
    public PojoScopeSchemaManager schemaManager() {
        return new PojoScopeSchemaManagerImpl(this.targetedTypeContexts);
    }

    @Override
    @Deprecated
    public PojoMassIndexer massIndexer(PojoMassIndexingContext context, DetachedBackendSessionContext detachedSession) {
        String tenantIdentifier = detachedSession.tenantIdentifier();
        return this.massIndexer(context, CollectionHelper.asSetIgnoreNull((Object[])new String[]{tenantIdentifier}));
    }

    @Override
    public PojoMassIndexer massIndexer(PojoMassIndexingContext context, Set<String> tenantIds) {
        return new PojoDefaultMassIndexer(context, this.mappingContext, this.indexedTypeContextProvider, this.targetedTypeContexts, this.schemaManager(), tenantIds, this);
    }

    @Override
    public <T> T extension(IndexScopeExtension<T> extension) {
        return (T)this.getIndexScope().extension(extension);
    }

    private MappedIndexScope<R, E> getIndexScope() {
        if (this.delegate == null) {
            Iterator<PojoScopeIndexedTypeContext<?, E>> iterator = this.targetedTypeContexts.iterator();
            MappedIndexScopeBuilder builder = iterator.next().createScopeBuilder(this.mappingContext);
            while (iterator.hasNext()) {
                iterator.next().addTo(builder);
            }
            this.delegate = builder.build();
        }
        return this.delegate;
    }
}

