/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.identity.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Supplier;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeMappingContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.spi.BridgeSessionContext;
import org.hibernate.search.mapper.pojo.identity.impl.IdentifierMappingImplementor;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.spi.PojoCaster;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reflect.spi.ValueReadHandle;

public final class UnmappedPropertyIdentifierMapping<I, E>
implements IdentifierMappingImplementor<I, E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final PojoCaster<? super I> caster;
    private final ValueReadHandle<I> property;
    private final PojoRawTypeIdentifier<E> typeIdentifier;

    public UnmappedPropertyIdentifierMapping(PojoRawTypeIdentifier<E> typeIdentifier, PojoCaster<? super I> caster, ValueReadHandle<I> property) {
        this.caster = caster;
        this.property = property;
        this.typeIdentifier = typeIdentifier;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[entityType = " + String.valueOf(this.typeIdentifier) + "]";
    }

    @Override
    public void close() {
    }

    @Override
    public I getIdentifier(Object providedId, Supplier<? extends E> entitySupplierOrNull) {
        if (providedId != null) {
            return this.caster.cast(providedId);
        }
        if (entitySupplierOrNull == null) {
            throw log.nullProvidedIdentifierAndEntity();
        }
        return (I)this.property.get(entitySupplierOrNull.get());
    }

    @Override
    public I getIdentifierOrNull(E entity) {
        return (I)this.property.get(entity);
    }

    @Override
    public String toDocumentIdentifier(Object identifier, BridgeMappingContext context) {
        throw log.cannotWorkWithIdentifierBecauseUnconfiguredIdentifierMapping(this.typeIdentifier);
    }

    @Override
    public I fromDocumentIdentifier(String documentId, BridgeSessionContext sessionContext) {
        throw log.cannotWorkWithIdentifierBecauseUnconfiguredIdentifierMapping(this.typeIdentifier);
    }
}

