/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.massindexing.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.engine.common.EntityReference;
import org.hibernate.search.mapper.pojo.loading.spi.PojoLoadingTypeContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassLoadingContext;
import org.hibernate.search.mapper.pojo.loading.spi.PojoMassLoadingStrategy;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.pojo.massindexing.impl.PojoMassIndexingTypeContextProvider;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingMappingContext;
import org.hibernate.search.mapper.pojo.massindexing.spi.PojoMassIndexingSessionContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;

public class PojoMassIndexingIndexedTypeGroup<E> {
    private final PojoMassLoadingStrategy<E, ?> loadingStrategy;
    private final PojoMassIndexingIndexedTypeContext<? extends E> commonSuperType;
    private final PojoMassIndexingMappingContext mappingContext;
    private final PojoMassIndexingTypeContextProvider typeContextProvider;
    private final Set<PojoMassIndexingIndexedTypeContext<? extends E>> includedTypes;
    private final PojoMassLoadingContext loadingContext;
    private Boolean groupingAllowed;

    public static List<PojoMassIndexingIndexedTypeGroup<?>> disjoint(PojoMassIndexingMappingContext mappingContext, PojoMassIndexingTypeContextProvider typeContextProvider, Set<? extends PojoMassIndexingIndexedTypeContext<?>> indexedTypeContexts, PojoMassLoadingContext loadingContext) {
        ArrayList typeGroups = new ArrayList();
        for (PojoMassIndexingIndexedTypeContext<?> typeContext : indexedTypeContexts) {
            PojoMassIndexingIndexedTypeGroup<?> typeGroup = PojoMassIndexingIndexedTypeGroup.single(mappingContext, typeContextProvider, typeContext, loadingContext);
            ListIterator iterator = typeGroups.listIterator();
            while (iterator.hasNext()) {
                PojoMassIndexingIndexedTypeGroup<?> mergeResult = ((PojoMassIndexingIndexedTypeGroup)iterator.next()).mergeOrNull(typeGroup);
                if (mergeResult == null) continue;
                typeGroup = mergeResult;
                iterator.remove();
            }
            typeGroups.add(typeGroup);
        }
        return typeGroups;
    }

    private static <E> PojoMassIndexingIndexedTypeGroup<? super E> single(PojoMassIndexingMappingContext mappingContext, PojoMassIndexingTypeContextProvider typeContextProvider, PojoMassIndexingIndexedTypeContext<E> typeContext, PojoMassLoadingContext loadingContext) {
        PojoMassLoadingStrategy strategy = typeContext.massLoadingStrategy();
        return new PojoMassIndexingIndexedTypeGroup<E>(strategy, typeContext, mappingContext, typeContextProvider, Collections.singleton(typeContext), loadingContext);
    }

    private PojoMassIndexingIndexedTypeGroup(PojoMassLoadingStrategy<E, ?> loadingStrategy, PojoMassIndexingIndexedTypeContext<? extends E> commonSuperType, PojoMassIndexingMappingContext mappingContext, PojoMassIndexingTypeContextProvider typeContextProvider, Set<PojoMassIndexingIndexedTypeContext<? extends E>> includedTypes, PojoMassLoadingContext loadingContext) {
        this.commonSuperType = commonSuperType;
        this.mappingContext = mappingContext;
        this.typeContextProvider = typeContextProvider;
        this.loadingStrategy = loadingStrategy;
        this.includedTypes = includedTypes;
        this.loadingContext = loadingContext;
        if (includedTypes.size() > 1) {
            this.groupingAllowed = true;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[commonSuperType=" + String.valueOf(this.commonSuperType) + ", loadingStrategy=" + String.valueOf(this.includedTypes) + ", includedSubTypes=" + String.valueOf(this.includedTypes) + "]";
    }

    public String notifiedGroupName() {
        return this.includedTypes.stream().map(PojoLoadingTypeContext::entityName).collect(Collectors.joining(","));
    }

    public Set<PojoMassIndexingIndexedTypeContext<? extends E>> includedTypes() {
        return this.includedTypes;
    }

    private boolean groupingAllowed() {
        if (this.groupingAllowed == null) {
            this.groupingAllowed = this.loadingStrategy.groupingAllowed(this.includedTypes.iterator().next(), this.loadingContext);
        }
        return this.groupingAllowed;
    }

    public EntityReference extractReference(PojoMassIndexingSessionContext sessionContext, Object entity) {
        PojoRawTypeIdentifier<Object> targetType = sessionContext.runtimeIntrospector().detectEntityType(entity);
        PojoMassIndexingIndexedTypeContext<Object> typeContext = this.typeContextProvider.indexedForExactType(targetType);
        String entityName = typeContext.entityName();
        Object identifier = this.extractIdentifier(typeContext, sessionContext, entity);
        return this.mappingContext.entityReferenceFactoryDelegate().create(targetType, entityName, identifier);
    }

    public EntityReference makeSuperTypeReference(Object identifier) {
        return this.mappingContext.entityReferenceFactoryDelegate().create(this.commonSuperType.typeIdentifier(), this.commonSuperType.entityName(), identifier);
    }

    public <E2> Object extractIdentifier(PojoMassIndexingIndexedTypeContext<E2> typeContext, PojoMassIndexingSessionContext sessionContext, Object entity) {
        return typeContext.identifierMapping().getIdentifier(null, typeContext.toEntitySupplier(sessionContext, entity));
    }

    public PojoMassLoadingStrategy<E, ?> loadingStrategy() {
        return this.loadingStrategy;
    }

    private PojoMassIndexingIndexedTypeGroup<?> mergeOrNull(PojoMassIndexingIndexedTypeGroup<?> other) {
        if (!this.loadingStrategy.equals(other.loadingStrategy)) {
            return null;
        }
        if (!this.groupingAllowed() || !other.groupingAllowed()) {
            return null;
        }
        if (this.isFirstSuperTypeOfSecond(this.commonSuperType, other.commonSuperType)) {
            return this.withAdditionalTypes(other.includedTypes);
        }
        if (this.isFirstSuperTypeOfSecond(other.commonSuperType, this.commonSuperType)) {
            return other.withAdditionalTypes(this.includedTypes);
        }
        return null;
    }

    private boolean isFirstSuperTypeOfSecond(PojoMassIndexingIndexedTypeContext<?> first, PojoMassIndexingIndexedTypeContext<?> second) {
        return this.typeContextProvider.indexedForSuperType(first.typeIdentifier()).map(s -> s.contains(second)).orElse(false);
    }

    private PojoMassIndexingIndexedTypeGroup<E> withAdditionalTypes(Set<? extends PojoMassIndexingIndexedTypeContext<? extends E>> otherIncludedSubTypes) {
        LinkedHashSet<PojoMassIndexingIndexedTypeContext<? extends PojoMassIndexingIndexedTypeContext<? extends E>>> mergedIncludedSubTypes = new LinkedHashSet<PojoMassIndexingIndexedTypeContext<? extends PojoMassIndexingIndexedTypeContext<? extends E>>>(this.includedTypes);
        mergedIncludedSubTypes.addAll(otherIncludedSubTypes);
        return new PojoMassIndexingIndexedTypeGroup<E>(this.loadingStrategy, this.commonSuperType, this.mappingContext, this.typeContextProvider, mergedIncludedSubTypes, this.loadingContext);
    }
}

