/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.automaticindexing.building.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.mapper.pojo.automaticindexing.ReindexOnUpdate;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoAssociationPathInverter;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoImplicitReindexingResolverBuilder;
import org.hibernate.search.mapper.pojo.automaticindexing.building.impl.PojoIndexingDependencyCollectorTypeNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingAssociationInverseSideResolver;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingAssociationInverseSideResolverMarkingNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingAssociationInverseSideResolverNode;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolver;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverImpl;
import org.hibernate.search.mapper.pojo.automaticindexing.impl.PojoImplicitReindexingResolverNode;
import org.hibernate.search.mapper.pojo.extractor.impl.BoundContainerExtractorPath;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorBinder;
import org.hibernate.search.mapper.pojo.extractor.impl.ContainerExtractorHolder;
import org.hibernate.search.mapper.pojo.extractor.mapping.programmatic.ContainerExtractorPath;
import org.hibernate.search.mapper.pojo.logging.impl.Log;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataProvider;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoEntityTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.PojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoPathOrdinalReference;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoPathOrdinals;
import org.hibernate.search.mapper.pojo.model.path.impl.PojoRuntimePathsBuildingHelper;
import org.hibernate.search.mapper.pojo.model.path.spi.BindablePojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoModelPathBinder;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathDefinition;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathEntityStateRepresentation;
import org.hibernate.search.mapper.pojo.model.path.spi.PojoPathFilter;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.mapper.pojo.reporting.spi.PojoEventContexts;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class PojoImplicitReindexingResolverBuildingHelper {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final ContainerExtractorBinder extractorBinder;
    private final PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider;
    private final PojoAssociationPathInverter pathInverter;
    private final Set<PojoRawTypeModel<?>> entityTypes;
    private final ReindexOnUpdate defaultReindexOnUpdate;
    private final Map<PojoRawTypeModel<?>, Set<PojoRawTypeModel<?>>> concreteEntitySubTypesByEntitySuperType = new HashMap();
    private final Map<PojoRawTypeModel<?>, PojoImplicitReindexingResolverBuilder<?>> builderByType = new HashMap();
    private final Map<PojoRawTypeModel<?>, PojoRuntimePathsBuildingHelper> runtimePathsBuildingHelperByType = new HashMap();

    public PojoImplicitReindexingResolverBuildingHelper(ContainerExtractorBinder extractorBinder, PojoTypeAdditionalMetadataProvider typeAdditionalMetadataProvider, Set<PojoRawTypeModel<?>> entityTypes, ReindexOnUpdate defaultReindexOnUpdate) {
        this.extractorBinder = extractorBinder;
        this.typeAdditionalMetadataProvider = typeAdditionalMetadataProvider;
        this.pathInverter = new PojoAssociationPathInverter(typeAdditionalMetadataProvider, extractorBinder);
        this.entityTypes = entityTypes;
        this.defaultReindexOnUpdate = defaultReindexOnUpdate;
        for (PojoRawTypeModel<?> pojoRawTypeModel : entityTypes) {
            if (pojoRawTypeModel.isAbstract()) continue;
            pojoRawTypeModel.ascendingSuperTypes().forEach(superType -> this.concreteEntitySubTypesByEntitySuperType.computeIfAbsent((PojoRawTypeModel<?>)superType, ignored -> new LinkedHashSet()).add(entityType));
        }
        for (Map.Entry entry : this.concreteEntitySubTypesByEntitySuperType.entrySet()) {
            entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
        }
    }

    public <T> PojoIndexingDependencyCollectorTypeNode<T> createDependencyCollector(PojoRawTypeModel<T> typeModel) {
        return new PojoIndexingDependencyCollectorTypeNode<T>(typeModel, this);
    }

    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(PojoImplicitReindexingResolverBuilder::closeOnFailure, this.builderByType.values());
        }
    }

    public <T> PojoImplicitReindexingResolver<T> build(PojoRawTypeModel<T> typeModel) {
        return this.buildOptional(typeModel).orElseGet(() -> {
            PojoRuntimePathsBuildingHelper helper = this.runtimePathsBuildingHelper(typeModel);
            PojoPathFilter emptyFilter = helper.createFilter(Collections.emptySet());
            return new PojoImplicitReindexingResolverImpl(emptyFilter, emptyFilter, PojoImplicitReindexingResolverNode.noOp(), this.createAssociationInverseSideResolver(typeModel, Collections.emptyMap()));
        });
    }

    public <T> Optional<PojoImplicitReindexingResolver<T>> buildOptional(PojoRawTypeModel<T> typeModel) {
        PojoImplicitReindexingResolverBuilder<?> builder = this.builderByType.get(typeModel);
        if (builder == null) {
            return Optional.empty();
        }
        return builder.build();
    }

    public <T> PojoRuntimePathsBuildingHelper runtimePathsBuildingHelper(PojoRawTypeModel<T> typeModel) {
        return this.runtimePathsBuildingHelperByType.computeIfAbsent(typeModel, theTypeModel -> {
            PojoEntityTypeAdditionalMetadata entityTypeMetadata = this.typeAdditionalMetadataProvider.get((PojoRawTypeModel<?>)theTypeModel).getEntityTypeMetadata().orElseThrow(() -> new AssertionFailure("Missing metadata for entity type '" + String.valueOf(theTypeModel)));
            return new PojoRuntimePathsBuildingHelper(entityTypeMetadata.pathDefinitionProvider());
        });
    }

    public PojoImplicitReindexingAssociationInverseSideResolver createAssociationInverseSideResolver(PojoRawTypeModel<?> typeModel, Map<PojoModelPathValueNode, Map<PojoRawTypeModel<?>, PojoModelPathValueNode>> inversePathByInverseTypeByDirectContainingPath) {
        PojoRuntimePathsBuildingHelper pathsBuildingHelper = this.runtimePathsBuildingHelper(typeModel);
        List<List<PojoImplicitReindexingAssociationInverseSideResolverNode<Object>>> resolversByOrdinal = this.createResolversByOrdinal(typeModel, pathsBuildingHelper, inversePathByInverseTypeByDirectContainingPath);
        PojoPathFilter filter = pathsBuildingHelper.createFilterForNonNullOrdinals(resolversByOrdinal);
        return new PojoImplicitReindexingAssociationInverseSideResolver(pathsBuildingHelper.pathOrdinals(), filter, resolversByOrdinal);
    }

    private List<List<PojoImplicitReindexingAssociationInverseSideResolverNode<Object>>> createResolversByOrdinal(PojoRawTypeModel<?> typeModel, PojoRuntimePathsBuildingHelper pathsBuildingHelper, Map<PojoModelPathValueNode, Map<PojoRawTypeModel<?>, PojoModelPathValueNode>> inversePathByInverseTypeByDirectContainingPath) {
        ArrayList<List<PojoImplicitReindexingAssociationInverseSideResolverNode<Object>>> result = new ArrayList<List<PojoImplicitReindexingAssociationInverseSideResolverNode<Object>>>();
        for (Map.Entry<PojoModelPathValueNode, Map<PojoRawTypeModel<?>, PojoModelPathValueNode>> entry : inversePathByInverseTypeByDirectContainingPath.entrySet()) {
            PojoImplicitReindexingAssociationInverseSideResolverNode<Object> nodeForOrdinal;
            int ordinal;
            PojoModelPathValueNode path = entry.getKey();
            Map<PojoRawTypeModel<?>, PojoModelPathValueNode> inversePathByInverseType = entry.getValue();
            try {
                BoundPojoModelPathValueNode<?, ?, ?> boundPath = this.bindPath(typeModel, path);
                PojoPathDefinition pathDefinition = pathsBuildingHelper.toPathDefinition(boundPath.toUnboundPath());
                Optional<PojoPathEntityStateRepresentation> entityStateRepresentationOptional = pathDefinition.entityStateRepresentation();
                if (!entityStateRepresentationOptional.isPresent()) continue;
                PojoPathEntityStateRepresentation entityStateRepresentation = entityStateRepresentationOptional.get();
                ordinal = entityStateRepresentation.ordinalInStateArray();
                for (int i = result.size(); i <= ordinal; ++i) {
                    result.add(null);
                }
                nodeForOrdinal = this.createAssociationInverseSideResolverNode(entityStateRepresentation.pathFromStateArrayElement(), inversePathByInverseType);
            }
            catch (RuntimeException e) {
                AssertionFailure assertionFailure = e instanceof AssertionFailure ? (AssertionFailure)e : new AssertionFailure(e.getMessage(), (Throwable)e);
                log.failedToCreateImplicitReindexingAssociationInverseSideResolverNode(inversePathByInverseType, EventContexts.fromType(typeModel).append(PojoEventContexts.fromPath(path)), assertionFailure.getMessage(), (Exception)assertionFailure);
                continue;
            }
            ArrayList<PojoImplicitReindexingAssociationInverseSideResolverNode<Object>> nodesForOrdinal = (ArrayList<PojoImplicitReindexingAssociationInverseSideResolverNode<Object>>)result.get(ordinal);
            if (nodesForOrdinal == null) {
                nodesForOrdinal = new ArrayList<PojoImplicitReindexingAssociationInverseSideResolverNode<Object>>();
                result.set(ordinal, nodesForOrdinal);
            }
            nodesForOrdinal.add(nodeForOrdinal);
        }
        return result;
    }

    private PojoImplicitReindexingAssociationInverseSideResolverNode<Object> createAssociationInverseSideResolverNode(Optional<BindablePojoModelPath> pathFromStateArrayElementOptional, Map<PojoRawTypeModel<?>, PojoModelPathValueNode> inverseSide) {
        HashMap ordinalByType = new HashMap();
        for (Map.Entry<PojoRawTypeModel<?>, PojoModelPathValueNode> entry : inverseSide.entrySet()) {
            PojoRawTypeModel<?> typeModel = entry.getKey();
            PojoModelPathValueNode path = entry.getValue();
            PojoRuntimePathsBuildingHelper inverseSideRuntimePathsHelper = this.runtimePathsBuildingHelper(typeModel);
            PojoPathOrdinals ordinals = inverseSideRuntimePathsHelper.pathOrdinals();
            int firstOrdinal = ordinals.toExistingOrNewOrdinal(inverseSideRuntimePathsHelper.toPathDefinition(path).stringRepresentations().iterator().next());
            ordinalByType.put(typeModel.typeIdentifier(), new PojoPathOrdinalReference(firstOrdinal, ordinals));
        }
        PojoImplicitReindexingAssociationInverseSideResolverMarkingNode markingNode = new PojoImplicitReindexingAssociationInverseSideResolverMarkingNode(ordinalByType);
        if (!pathFromStateArrayElementOptional.isPresent()) {
            return markingNode;
        }
        BindablePojoModelPath pathFromStateArrayElement = pathFromStateArrayElementOptional.get();
        BoundPojoModelPathValueNode<?, ?, ?> boundPath = this.bindPath(pathFromStateArrayElement.rootType(), pathFromStateArrayElement.path());
        return PojoImplicitReindexingAssociationInverseSideResolverNode.bind(this.extractorBinder, boundPath, markingNode);
    }

    public BoundPojoModelPathValueNode<?, ?, ?> bindPath(PojoTypeModel<?> rootType, PojoModelPathValueNode unboundPath) {
        return (BoundPojoModelPathValueNode)PojoModelPathBinder.bind(BoundPojoModelPath.root(rootType), unboundPath, BoundPojoModelPath.walker(this.extractorBinder));
    }

    public boolean isSingleConcreteTypeInEntityHierarchy(PojoRawTypeModel<?> typeModel) {
        return typeModel.ascendingSuperTypes().filter(this::isEntity).allMatch(t -> this.getConcreteEntitySubTypesForEntitySuperType((PojoRawTypeModel<?>)t).size() <= 1);
    }

    PojoAssociationPathInverter pathInverter() {
        return this.pathInverter;
    }

    boolean isEntity(PojoRawTypeModel<?> typeModel) {
        return this.entityTypes.contains(typeModel);
    }

    public Set<? extends PojoRawTypeModel<?>> getConcreteEntitySubTypesForEntitySuperType(PojoRawTypeModel<?> superTypeModel) {
        return this.concreteEntitySubTypesByEntitySuperType.computeIfAbsent(superTypeModel, ignored -> Collections.emptySet());
    }

    <T> PojoImplicitReindexingResolverBuilder<T> getOrCreateResolverBuilder(PojoRawTypeModel<T> rawTypeModel) {
        PojoImplicitReindexingResolverBuilder<Object> builder = this.builderByType.get(rawTypeModel);
        if (builder == null) {
            builder = new PojoImplicitReindexingResolverBuilder<T>(rawTypeModel, this);
            this.builderByType.put(rawTypeModel, builder);
        }
        return builder;
    }

    ContainerExtractorBinder extractorBinder() {
        return this.extractorBinder;
    }

    <V, T> ContainerExtractorHolder<T, V> createExtractors(BoundContainerExtractorPath<T, V> boundExtractorPath) {
        return this.extractorBinder.create(boundExtractorPath);
    }

    ReindexOnUpdate getDefaultReindexOnUpdate() {
        return this.defaultReindexOnUpdate;
    }

    ReindexOnUpdate getMetadataReindexOnUpdateOrNull(PojoTypeModel<?> typeModel, String propertyName, ContainerExtractorPath extractorPath) {
        PojoTypeAdditionalMetadata typeAdditionalMetadata = this.typeAdditionalMetadataProvider.get(typeModel.rawType());
        Optional<ReindexOnUpdate> reindexOnUpdateOptional = typeAdditionalMetadata.getPropertyAdditionalMetadata(propertyName).getValueAdditionalMetadata(extractorPath).getReindexOnUpdate();
        if (reindexOnUpdateOptional.isPresent()) {
            return reindexOnUpdateOptional.get();
        }
        if (this.extractorBinder.isDefaultExtractorPath(typeModel.property(propertyName).typeModel(), extractorPath)) {
            reindexOnUpdateOptional = typeAdditionalMetadata.getPropertyAdditionalMetadata(propertyName).getValueAdditionalMetadata(ContainerExtractorPath.defaultExtractors()).getReindexOnUpdate();
        }
        return reindexOnUpdateOptional.orElse(null);
    }

    Set<PojoModelPathValueNode> getMetadataDerivedFrom(PojoTypeModel<?> typeModel, String propertyName, ContainerExtractorPath extractorPath) {
        PojoTypeAdditionalMetadata typeAdditionalMetadata = this.typeAdditionalMetadataProvider.get(typeModel.rawType());
        Set<PojoModelPathValueNode> derivedFrom = typeAdditionalMetadata.getPropertyAdditionalMetadata(propertyName).getValueAdditionalMetadata(extractorPath).getDerivedFrom();
        if (derivedFrom.isEmpty() && this.extractorBinder.isDefaultExtractorPath(typeModel.property(propertyName).typeModel(), extractorPath)) {
            derivedFrom = typeAdditionalMetadata.getPropertyAdditionalMetadata(propertyName).getValueAdditionalMetadata(ContainerExtractorPath.defaultExtractors()).getDerivedFrom();
        }
        return derivedFrom;
    }
}

