/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.common.impl;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class SearchThreadFactory
implements ThreadFactory {
    private static final String THREAD_GROUP_PREFIX = "Hibernate Search: ";
    final ThreadGroup group;
    final AtomicInteger threadNumber = new AtomicInteger(1);
    final String namePrefix;

    public SearchThreadFactory(String groupname) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = THREAD_GROUP_PREFIX + groupname + "-";
    }

    @Override
    public Thread newThread(Runnable r) {
        return new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
    }
}

