/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.export.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.tool.api.export.ArtifactCollector;
import org.hibernate.tool.internal.xml.XMLPrettyPrinter;

public class DefaultArtifactCollector
implements ArtifactCollector {
    protected final Map<String, List<File>> files = new HashMap<String, List<File>>();

    @Override
    public void addFile(File file, String type) {
        List<File> existing = this.files.get(type);
        if (existing == null) {
            existing = new ArrayList<File>();
            this.files.put(type, existing);
        }
        existing.add(file);
    }

    @Override
    public int getFileCount(String type) {
        List<File> existing = this.files.get(type);
        return existing == null ? 0 : existing.size();
    }

    @Override
    public File[] getFiles(String type) {
        List<File> existing = this.files.get(type);
        if (existing == null) {
            return new File[0];
        }
        return existing.toArray(new File[existing.size()]);
    }

    @Override
    public Set<String> getFileTypes() {
        return this.files.keySet();
    }

    @Override
    public void formatFiles() {
        this.formatXml("xml");
        this.formatXml("hbm.xml");
        this.formatXml("cfg.xml");
    }

    private void formatXml(String type) {
        List<File> list = this.files.get(type);
        if (list != null && !list.isEmpty()) {
            for (File xmlFile : list) {
                try {
                    XMLPrettyPrinter.prettyPrintFile(xmlFile);
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not format XML file: " + xmlFile, e);
                }
            }
        }
    }
}

