/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.reader;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.RevengDialect;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.api.reveng.TableIdentifier;
import org.hibernate.tool.internal.reveng.RevengMetadataCollector;
import org.hibernate.tool.internal.reveng.reader.BasicColumnProcessor;
import org.hibernate.tool.internal.reveng.reader.IndexProcessor;
import org.hibernate.tool.internal.reveng.reader.PrimaryKeyProcessor;
import org.jboss.logging.Logger;

public class TableCollector {
    private static final Logger log = Logger.getLogger(TableCollector.class);
    private RevengDialect metaDataDialect;
    private RevengStrategy revengStrategy;
    private RevengMetadataCollector revengMetadataCollector;
    private Properties properties;

    public static TableCollector create(RevengDialect metaDataDialect, RevengStrategy revengStrategy, RevengMetadataCollector revengMetadataCollector, Properties properties) {
        return new TableCollector(metaDataDialect, revengStrategy, revengMetadataCollector, properties);
    }

    private TableCollector(RevengDialect metaDataDialect, RevengStrategy revengStrategy, RevengMetadataCollector revengMetadataCollector, Properties properties) {
        this.metaDataDialect = metaDataDialect;
        this.revengStrategy = revengStrategy;
        this.revengMetadataCollector = revengMetadataCollector;
        this.properties = properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Table, Boolean> processTables(RevengStrategy.SchemaSelection schemaSelection) {
        Iterator<Map<String, Object>> tableIterator = null;
        HashMap<Table, Boolean> processedTables = new HashMap<Table, Boolean>();
        try {
            tableIterator = this.metaDataDialect.getTables(StringHelper.replace((String)schemaSelection.getMatchCatalog(), (String)".*", (String)"%"), StringHelper.replace((String)schemaSelection.getMatchSchema(), (String)".*", (String)"%"), StringHelper.replace((String)schemaSelection.getMatchTable(), (String)".*", (String)"%"));
            while (tableIterator.hasNext()) {
                this.processTable(tableIterator.next(), processedTables);
            }
        }
        finally {
            if (tableIterator != null) {
                this.metaDataDialect.close(tableIterator);
            }
        }
        return processedTables;
    }

    private void processTable(Map<String, Object> tableRs, HashMap<Table, Boolean> processedTables) {
        TableIdentifier tableIdentifier = TableIdentifier.create(this.quote((String)tableRs.get("TABLE_CAT")), this.quote((String)tableRs.get("TABLE_SCHEM")), this.quote((String)tableRs.get("TABLE_NAME")));
        if (this.revengStrategy.excludeTable(tableIdentifier)) {
            log.debug((Object)("Table " + tableIdentifier + " excluded by strategy"));
        } else if (this.revengMetadataCollector.getTable(tableIdentifier) != null) {
            log.debug((Object)("Ignoring " + tableIdentifier + " since it has already been processed"));
        } else {
            this.addTable(tableIdentifier, (String)tableRs.get("TABLE_TYPE"), (String)tableRs.get("REMARKS"), processedTables);
        }
    }

    private void addTable(TableIdentifier tableIdentifier, String tableType, String comment, HashMap<Table, Boolean> processedTables) {
        if (this.isTypeToAdd(tableType)) {
            log.debug((Object)("Adding table " + tableIdentifier + " of type " + tableType));
            Table table = this.revengMetadataCollector.addTable(tableIdentifier);
            table.setComment(comment);
            BasicColumnProcessor.processBasicColumns(this.metaDataDialect, this.revengStrategy, this.properties.getProperty("hibernate.default_schema"), this.properties.getProperty("hibernate.default_catalog"), table);
            PrimaryKeyProcessor.processPrimaryKey(this.metaDataDialect, this.revengStrategy, this.properties.getProperty("hibernate.default_schema"), this.properties.getProperty("hibernate.default_catalog"), this.revengMetadataCollector, table);
            if (tableType.equalsIgnoreCase("TABLE")) {
                IndexProcessor.processIndices(this.metaDataDialect, this.properties.getProperty("hibernate.default_schema"), this.properties.getProperty("hibernate.default_catalog"), table);
            }
            processedTables.put(table, tableType.equalsIgnoreCase("TABLE"));
        } else {
            log.debug((Object)("Ignoring table " + tableIdentifier + " of type " + tableType));
        }
    }

    private boolean isTypeToAdd(String tableType) {
        return "TABLE".equalsIgnoreCase(tableType) || "VIEW".equalsIgnoreCase(tableType) || "SYNONYM".equals(tableType);
    }

    private String quote(String name) {
        if (name == null) {
            return name;
        }
        if (this.metaDataDialect.needQuote(name)) {
            if (name.length() > 1 && name.charAt(0) == '`' && name.charAt(name.length() - 1) == '`') {
                return name;
            }
            return "`" + name + "`";
        }
        return name;
    }
}

