/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue;

import java.net.URI;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.rest.queue.ConsumedMessage;
import org.hornetq.rest.queue.DestinationServiceManager;
import org.hornetq.rest.util.LinkStrategy;

public class QueueConsumer {
    protected ClientSessionFactory factory;
    protected ClientSession session;
    protected ClientConsumer consumer;
    protected String destination;
    protected boolean closed;
    protected String id;
    protected long lastPing = System.currentTimeMillis();
    protected DestinationServiceManager serviceManager;
    protected boolean autoAck = true;
    protected long previousIndex = -1L;
    protected ConsumedMessage lastConsumed;

    public long getConsumeIndex() {
        if (this.lastConsumed == null) {
            return -1L;
        }
        return this.lastConsumed.getMessageID();
    }

    public DestinationServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(DestinationServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public long getLastPingTime() {
        return this.lastPing;
    }

    protected void ping() {
        this.lastPing = System.currentTimeMillis();
    }

    public QueueConsumer(ClientSessionFactory factory, String destination, String id, DestinationServiceManager serviceManager) throws HornetQException {
        this.factory = factory;
        this.destination = destination;
        this.id = id;
        this.serviceManager = serviceManager;
        this.createSession(factory, destination);
    }

    public String getId() {
        return this.id;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public synchronized void shutdown() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.lastConsumed = null;
        this.previousIndex = -2L;
        try {
            this.consumer.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.session = null;
        this.consumer = null;
    }

    @Path(value="consume-next{index}")
    @POST
    public synchronized Response poll(@HeaderParam(value="Accept-Wait") @DefaultValue(value="0") long wait, @PathParam(value="index") long index, @Context UriInfo info) {
        if (this.closed) {
            UriBuilder builder = info.getBaseUriBuilder();
            builder.path((String)info.getMatchedURIs().get(1)).path("consume-next");
            String uri = builder.build(new Object[0]).toString();
            return Response.status((int)307).location(URI.create(uri)).build();
        }
        return this.checkIndexAndPoll(wait, info, (String)info.getMatchedURIs().get(1), index);
    }

    public synchronized Response runPoll(long wait, UriInfo info, String basePath) {
        this.ping();
        return this.pollWithIndex(wait, info, basePath, -1L);
    }

    protected Response checkIndexAndPoll(long wait, UriInfo info, String basePath, long index) {
        this.ping();
        if (this.lastConsumed == null && index > 0L) {
            return Response.status((int)412).entity((Object)"You are using an old consume-next link and are out of sync with the JMS session on the server").type("text/plain").build();
        }
        if (this.lastConsumed != null) {
            if (index == this.previousIndex) {
                String token = Long.toString(this.lastConsumed.getMessageID());
                return this.getMessageResponse(this.lastConsumed, info, basePath, token).build();
            }
            if (index != this.lastConsumed.getMessageID()) {
                return Response.status((int)412).entity((Object)"You are using an old consume-next link and are out of sync with the JMS session on the server").type("text/plain").build();
            }
        }
        return this.pollWithIndex(wait, info, basePath, index);
    }

    protected Response pollWithIndex(long wait, UriInfo info, String basePath, long index) {
        try {
            ClientMessage message = this.receive(wait);
            if (message == null) {
                Response.ResponseBuilder builder = Response.status((int)503).entity((Object)"Timed out waiting for message receive.").type("text/plain");
                this.setPollTimeoutLinks(info, basePath, builder, Long.toString(index));
                return builder.build();
            }
            this.previousIndex = index;
            this.lastConsumed = ConsumedMessage.createConsumedMessage(message);
            String token = Long.toString(this.lastConsumed.getMessageID());
            Response response = this.getMessageResponse(this.lastConsumed, info, basePath, token).build();
            if (this.autoAck) {
                message.acknowledge();
            }
            return response;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void createSession(ClientSessionFactory factory, String destination) throws HornetQException {
        this.session = factory.createSession(true, true);
        this.consumer = this.session.createConsumer(destination);
        this.session.start();
    }

    protected ClientMessage receiveFromConsumer(long timeoutSecs) throws Exception {
        if (timeoutSecs <= 0L) {
            return this.consumer.receive(1L);
        }
        return this.consumer.receive(timeoutSecs * 1000L);
    }

    protected ClientMessage receive(long timeoutSecs) throws Exception {
        return this.receiveFromConsumer(timeoutSecs);
    }

    protected void setPollTimeoutLinks(UriInfo info, String basePath, Response.ResponseBuilder builder, String index) {
        this.setSessionLink(builder, info, basePath);
        QueueConsumer.setConsumeNextLink(this.serviceManager.getLinkStrategy(), builder, info, basePath, index);
    }

    protected Response.ResponseBuilder getMessageResponse(ConsumedMessage msg, UriInfo info, String basePath, String index) {
        Response.ResponseBuilder responseBuilder = Response.ok();
        this.setMessageResponseLinks(info, basePath, responseBuilder, index);
        msg.build(responseBuilder);
        return responseBuilder;
    }

    protected void setMessageResponseLinks(UriInfo info, String basePath, Response.ResponseBuilder responseBuilder, String index) {
        QueueConsumer.setConsumeNextLink(this.serviceManager.getLinkStrategy(), responseBuilder, info, basePath, index);
        this.setSessionLink(responseBuilder, info, basePath);
    }

    public static void setConsumeNextLink(LinkStrategy linkStrategy, Response.ResponseBuilder response, UriInfo info, String basePath, String index) {
        if (index == null) {
            throw new IllegalArgumentException("index cannot be null");
        }
        UriBuilder builder = info.getBaseUriBuilder();
        builder.path(basePath).path("consume-next" + index);
        String uri = builder.build(new Object[0]).toString();
        linkStrategy.setLinkHeader(response, "consume-next", "consume-next", uri, "application/x-www-form-urlencoded");
    }

    public void setSessionLink(Response.ResponseBuilder response, UriInfo info, String basePath) {
        UriBuilder builder = info.getBaseUriBuilder();
        builder.path(basePath);
        String uri = builder.build(new Object[0]).toString();
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "consumer", "consumer", uri, "application/xml");
    }
}

