/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest;

import java.lang.reflect.Type;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.jms.client.HornetQMessage;
import org.hornetq.rest.Hornetq;
import org.hornetq.rest.HttpHeaderProperty;
import org.hornetq.rest.UnknownMediaType;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GenericType;

public class Jms {
    public static void setHttpHeader(Message message, String name, String value) {
        try {
            message.setStringProperty(HttpHeaderProperty.toPropertyName(name), value);
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getHttpHeader(Message message, String name) {
        try {
            return message.getStringProperty(HttpHeaderProperty.toPropertyName(name));
        }
        catch (JMSException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getEntity(Message message, Class<T> type) {
        return Jms.getEntity(message, type, null, ResteasyProviderFactory.getInstance());
    }

    public static <T> T getEntity(Message message, Class<T> type, ResteasyProviderFactory factory) {
        return Jms.getEntity(message, type, null, factory);
    }

    public static <T> T getEntity(Message message, GenericType<T> type, ResteasyProviderFactory factory) throws UnknownMediaType {
        return Jms.getEntity(message, type.getType(), type.getGenericType(), factory);
    }

    public static boolean isHttpMessage(Message message) {
        ClientMessage msg = ((HornetQMessage)message).getCoreMessage();
        return Hornetq.isHttpMessage(msg);
    }

    public static <T> T getEntity(Message message, Class<T> type, Type genericType, ResteasyProviderFactory factory) throws UnknownMediaType {
        if (!Jms.isHttpMessage(message)) {
            try {
                return (T)((ObjectMessage)message).getObject();
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        }
        ClientMessage msg = ((HornetQMessage)message).getCoreMessage();
        return Hornetq.getEntity(msg, type, genericType, factory);
    }
}

