/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue;

import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.core.client.impl.ClientSessionFactoryImpl;
import org.hornetq.core.remoting.impl.invm.InVMConnectorFactory;
import org.hornetq.rest.integration.BindingRegistry;
import org.hornetq.rest.queue.DestinationSettings;
import org.hornetq.rest.util.LinkStrategy;
import org.hornetq.rest.util.TimeoutTask;

public abstract class DestinationServiceManager {
    protected ClientSessionFactory sessionFactory;
    protected ClientSessionFactory consumerSessionFactory;
    protected boolean started;
    protected String pushStoreFile;
    protected DestinationSettings defaultSettings = DestinationSettings.defaultSettings;
    protected TimeoutTask timeoutTask;
    protected int producerPoolSize;
    protected LinkStrategy linkStrategy;
    protected BindingRegistry registry;

    public BindingRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(BindingRegistry registry) {
        this.registry = registry;
    }

    public LinkStrategy getLinkStrategy() {
        return this.linkStrategy;
    }

    public void setLinkStrategy(LinkStrategy linkStrategy) {
        this.linkStrategy = linkStrategy;
    }

    public int getProducerPoolSize() {
        return this.producerPoolSize;
    }

    public void setProducerPoolSize(int producerPoolSize) {
        this.producerPoolSize = producerPoolSize;
    }

    public ClientSessionFactory getConsumerSessionFactory() {
        return this.consumerSessionFactory;
    }

    public void setConsumerSessionFactory(ClientSessionFactory consumerSessionFactory) {
        this.consumerSessionFactory = consumerSessionFactory;
    }

    public TimeoutTask getTimeoutTask() {
        return this.timeoutTask;
    }

    public void setTimeoutTask(TimeoutTask timeoutTask) {
        this.timeoutTask = timeoutTask;
    }

    public DestinationSettings getDefaultSettings() {
        return this.defaultSettings;
    }

    public void setDefaultSettings(DestinationSettings defaultSettings) {
        this.defaultSettings = defaultSettings;
    }

    public ClientSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(ClientSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getPushStoreFile() {
        return this.pushStoreFile;
    }

    public void setPushStoreFile(String pushStoreFile) {
        this.pushStoreFile = pushStoreFile;
    }

    protected void initDefaults() {
        if (this.sessionFactory == null) {
            this.sessionFactory = new ClientSessionFactoryImpl(new TransportConfiguration(InVMConnectorFactory.class.getName()));
        }
        if (this.consumerSessionFactory == null) {
            this.consumerSessionFactory = this.sessionFactory;
        }
        if (this.timeoutTask == null) {
            throw new RuntimeException("TimeoutTask is not set");
        }
    }

    public abstract void start() throws Exception;

    public abstract void stop();
}

