/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.topic;

import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.hornetq.rest.queue.DestinationResource;
import org.hornetq.rest.queue.PostMessage;
import org.hornetq.rest.topic.PushSubscriptionsResource;
import org.hornetq.rest.topic.SubscriptionsResource;

public class TopicResource
extends DestinationResource {
    protected SubscriptionsResource subscriptions;
    protected PushSubscriptionsResource pushSubscriptions;

    public void start() throws Exception {
    }

    public void stop() {
        this.subscriptions.stop();
        this.pushSubscriptions.stop();
        this.sender.cleanup();
    }

    @GET
    @Produces(value={"application/xml"})
    public Response get(@Context UriInfo uriInfo) {
        String msg = "<topic><name>" + this.destination + "</name>" + "</topic>";
        Response.ResponseBuilder builder = Response.ok((Object)msg);
        this.setSenderLink(builder, uriInfo);
        this.setSubscriptionsLink(builder, uriInfo);
        this.setPushSubscriptionsLink(builder, uriInfo);
        return builder.build();
    }

    @HEAD
    @Produces(value={"application/xml"})
    public Response head(@Context UriInfo uriInfo) {
        Response.ResponseBuilder builder = Response.ok();
        this.setSenderLink(builder, uriInfo);
        this.setSenderWithIdLink(builder, uriInfo);
        this.setSubscriptionsLink(builder, uriInfo);
        this.setPushSubscriptionsLink(builder, uriInfo);
        return builder.build();
    }

    protected void setSenderLink(Response.ResponseBuilder response, UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("create");
        String uri = builder.build(new Object[0]).toString();
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "create", "create", uri, null);
    }

    protected void setSenderWithIdLink(Response.ResponseBuilder response, UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("create");
        String uri = builder.build(new Object[0]).toString();
        uri = uri + "/{id}";
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "create-with-id", "create-with-id", uri, null);
    }

    protected void setSubscriptionsLink(Response.ResponseBuilder response, UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("pull-subscriptions");
        String uri = builder.build(new Object[0]).toString();
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "pull-subscriptions", "pull-subscriptions", uri, null);
    }

    protected void setPushSubscriptionsLink(Response.ResponseBuilder response, UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("push-subscriptions");
        String uri = builder.build(new Object[0]).toString();
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "push-subscriptions", "push-subscriptions", uri, null);
    }

    public void setSubscriptions(SubscriptionsResource subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Path(value="create")
    public PostMessage post() throws Exception {
        return this.sender;
    }

    @Path(value="pull-subscriptions")
    public SubscriptionsResource getSubscriptions() {
        return this.subscriptions;
    }

    @Path(value="push-subscriptions")
    public PushSubscriptionsResource getPushSubscriptions() {
        return this.pushSubscriptions;
    }

    public void setPushSubscriptions(PushSubscriptionsResource pushSubscriptions) {
        this.pushSubscriptions = pushSubscriptions;
    }
}

