/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.integration;

import javax.management.MBeanServer;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.config.impl.FileConfiguration;
import org.hornetq.core.server.HornetQServer;
import org.hornetq.core.server.impl.HornetQServerImpl;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.hornetq.spi.core.security.HornetQSecurityManagerImpl;

public class EmbeddedHornetQ {
    protected HornetQSecurityManager securityManager;
    protected FileConfiguration configuration = new FileConfiguration();
    protected HornetQServer hornetQServer;
    protected MBeanServer mbeanServer;

    public void setConfigurationFile(String filename) {
        this.configuration.setConfigurationUrl(filename);
    }

    public void setSecurityManager(HornetQSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public HornetQServer getHornetQServer() {
        return this.hornetQServer;
    }

    public void start() throws Exception {
        this.initStart();
        this.hornetQServer.start();
    }

    protected void initStart() throws Exception {
        this.configuration.start();
        if (this.securityManager == null) {
            this.securityManager = new HornetQSecurityManagerImpl();
        }
        this.hornetQServer = this.mbeanServer == null ? new HornetQServerImpl((Configuration)this.configuration, this.securityManager) : new HornetQServerImpl((Configuration)this.configuration, this.mbeanServer, this.securityManager);
    }

    public void stop() throws Exception {
        this.hornetQServer.stop();
    }
}

