/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.integration;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hornetq.rest.integration.BindingRegistry;
import org.hornetq.utils.JNDIUtil;

public class JndiComponentRegistry
implements BindingRegistry {
    private Context context;

    public JndiComponentRegistry(Context context) {
        this.context = context;
    }

    public JndiComponentRegistry() throws Exception {
        this.context = new InitialContext();
    }

    @Override
    public Object lookup(String name) {
        try {
            return this.context.lookup(name);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean bind(String name, Object obj) {
        try {
            return this.bindToJndi(name, obj);
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void unbind(String name) {
        try {
            this.context.unbind(name);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        try {
            this.context.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    private boolean bindToJndi(String jndiName, Object objectToBind) throws NamingException {
        if (this.context != null) {
            int sepIndex = jndiName.lastIndexOf(47);
            String parentContext = sepIndex == -1 ? "" : jndiName.substring(0, sepIndex);
            String jndiNameInContext = jndiName.substring(sepIndex + 1);
            try {
                this.context.lookup(jndiName);
                return false;
            }
            catch (Throwable e) {
                Context c = JNDIUtil.createContext((Context)this.context, (String)parentContext);
                c.rebind(jndiNameInContext, objectToBind);
            }
        }
        return true;
    }
}

