/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue;

import java.net.URI;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.rest.queue.DestinationServiceManager;
import org.hornetq.rest.util.HttpMessageHelper;

public class PostMessage {
    protected ClientSessionFactory sessionFactory;
    protected String destination;
    protected boolean defaultDurable = false;
    protected DestinationServiceManager serviceManager;
    private AtomicLong counter = new AtomicLong(1L);
    private final String startupTime = Long.toString(System.currentTimeMillis());
    protected ArrayBlockingQueue<Pooled> pool;
    protected int poolSize = 10;

    protected String generateDupId() {
        return this.startupTime + Long.toString(this.counter.incrementAndGet());
    }

    public void publish(HttpHeaders headers, byte[] body, String dup, boolean durable, Long expiration, Integer priority) throws Exception {
        Pooled pooled = this.getPooled();
        try {
            ClientProducer producer = pooled.producer;
            ClientMessage message = this.createHornetQMessage(headers, body, durable, expiration, priority, pooled.session);
            message.putStringProperty(ClientMessage.HDR_DUPLICATE_DETECTION_ID.toString(), dup);
            producer.send((Message)message);
            this.pool.add(pooled);
        }
        catch (Exception ex) {
            try {
                pooled.session.close();
            }
            catch (HornetQException e) {
                // empty catch block
            }
            this.addPooled();
            throw ex;
        }
    }

    @PUT
    @Path(value="{id}")
    public Response putWithId(@PathParam(value="id") String dupId, @QueryParam(value="durable") Boolean durable, @QueryParam(value="expiration") Long expiration, @QueryParam(value="priority") Integer priority, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) {
        return this.postWithId(dupId, durable, expiration, priority, headers, uriInfo, body);
    }

    @POST
    @Path(value="{id}")
    public Response postWithId(@PathParam(value="id") String dupId, @QueryParam(value="durable") Boolean durable, @QueryParam(value="expiration") Long expiration, @QueryParam(value="priority") Integer priority, @Context HttpHeaders headers, @Context UriInfo uriInfo, byte[] body) {
        String matched = (String)uriInfo.getMatchedURIs().get(1);
        UriBuilder nextBuilder = uriInfo.getBaseUriBuilder();
        String nextId = this.generateDupId();
        nextBuilder.path(matched).path(nextId);
        URI next = nextBuilder.build(new Object[0]);
        boolean isDurable = this.defaultDurable;
        if (durable != null) {
            isDurable = durable;
        }
        try {
            this.publish(headers, body, dupId, isDurable, expiration, priority);
        }
        catch (Exception e) {
            Response error = Response.serverError().entity((Object)("Problem posting message: " + e.getMessage())).type("text/plain").build();
            throw new WebApplicationException((Throwable)e, error);
        }
        Response.ResponseBuilder builder = Response.status((int)201);
        this.serviceManager.getLinkStrategy().setLinkHeader(builder, "create-next", "create-next", next.toString(), "*/*");
        return builder.build();
    }

    public DestinationServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(DestinationServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public ClientSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(ClientSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public boolean isDefaultDurable() {
        return this.defaultDurable;
    }

    public void setDefaultDurable(boolean defaultDurable) {
        this.defaultDurable = defaultDurable;
    }

    public int getPoolSize() {
        return this.poolSize;
    }

    public void setPoolSize(int poolSize) {
        this.poolSize = poolSize;
    }

    public void init() throws Exception {
        this.pool = new ArrayBlockingQueue(this.poolSize);
        for (int i = 0; i < this.poolSize; ++i) {
            this.addPooled();
        }
    }

    protected void addPooled() throws HornetQException {
        ClientSession session = this.sessionFactory.createSession();
        ClientProducer producer = session.createProducer(this.destination);
        session.start();
        this.pool.add(new Pooled(session, producer));
    }

    protected Pooled getPooled() throws InterruptedException {
        Pooled pooled = this.pool.poll(1L, TimeUnit.SECONDS);
        if (pooled == null) {
            throw new WebApplicationException(Response.status((int)503).entity((Object)"Timed out waiting for available producer.").type("text/plain").build());
        }
        return pooled;
    }

    public void cleanup() {
        for (Pooled pooled : this.pool) {
            try {
                pooled.session.close();
            }
            catch (HornetQException e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected ClientMessage createHornetQMessage(HttpHeaders headers, byte[] body, boolean durable, Long expiration, Integer priority, ClientSession session) throws Exception {
        byte p;
        ClientMessage message = session.createMessage(durable);
        if (expiration != null) {
            message.setExpiration(expiration.longValue());
        }
        if (priority != null && (p = priority.byteValue()) >= 0 && p <= 9) {
            message.setPriority(p);
        }
        HttpMessageHelper.writeHttpMessage(headers, body, message);
        return message;
    }

    protected static class Pooled {
        public ClientSession session;
        public ClientProducer producer;

        private Pooled(ClientSession session, ClientProducer producer) {
            this.session = session;
            this.producer = producer;
        }
    }
}

