/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue;

import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.hornetq.rest.queue.ConsumersResource;
import org.hornetq.rest.queue.DestinationResource;
import org.hornetq.rest.queue.PostMessage;
import org.hornetq.rest.queue.push.PushConsumerResource;

public class QueueResource
extends DestinationResource {
    protected ConsumersResource consumers;
    protected PushConsumerResource pushConsumers;

    public void start() throws Exception {
    }

    public void stop() {
        this.consumers.stop();
        this.pushConsumers.stop();
        this.sender.cleanup();
    }

    @GET
    @Produces(value={"application/xml"})
    public Response get(@Context UriInfo uriInfo) {
        String msg = "<queue><name>" + this.destination + "</name>" + "</queue>";
        Response.ResponseBuilder builder = Response.ok((Object)msg);
        this.setSenderLink(builder, uriInfo);
        this.setConsumersLink(builder, uriInfo);
        this.setPushConsumersLink(builder, uriInfo);
        return builder.build();
    }

    @HEAD
    @Produces(value={"application/xml"})
    public Response head(@Context UriInfo uriInfo) {
        Response.ResponseBuilder builder = Response.ok();
        this.setSenderLink(builder, uriInfo);
        this.setSenderWithIdLink(builder, uriInfo);
        this.setConsumersLink(builder, uriInfo);
        this.setPushConsumersLink(builder, uriInfo);
        return builder.build();
    }

    protected void setSenderLink(Response.ResponseBuilder response, UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("create");
        String uri = builder.build(new Object[0]).toString();
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "create", "create", uri, null);
    }

    protected void setSenderWithIdLink(Response.ResponseBuilder response, UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("create");
        String uri = builder.build(new Object[0]).toString();
        uri = uri + "/{id}";
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "create-with-id", "create-with-id", uri, null);
    }

    protected void setConsumersLink(Response.ResponseBuilder response, UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("pull-consumers");
        String uri = builder.build(new Object[0]).toString();
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "pull-consumers", "pull-consumers", uri, null);
    }

    protected void setPushConsumersLink(Response.ResponseBuilder response, UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("push-consumers");
        String uri = builder.build(new Object[0]).toString();
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "push-consumers", "push-consumers", uri, null);
    }

    public void setConsumers(ConsumersResource consumers) {
        this.consumers = consumers;
    }

    @Path(value="create")
    public PostMessage post() throws Exception {
        return this.sender;
    }

    @Path(value="pull-consumers")
    public ConsumersResource getConsumers() {
        return this.consumers;
    }

    public void setPushConsumers(PushConsumerResource pushConsumers) {
        this.pushConsumers = pushConsumers;
    }

    @Path(value="push-consumers")
    public PushConsumerResource getPushConsumers() {
        return this.pushConsumers;
    }
}

