/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue.push;

import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.api.core.client.MessageHandler;
import org.hornetq.core.logging.Logger;
import org.hornetq.jms.client.SelectorTranslator;
import org.hornetq.rest.queue.push.HornetQPushStrategy;
import org.hornetq.rest.queue.push.PushStrategy;
import org.hornetq.rest.queue.push.UriStrategy;
import org.hornetq.rest.queue.push.UriTemplateStrategy;
import org.hornetq.rest.queue.push.xml.PushRegistration;

public class PushConsumer
implements MessageHandler {
    private static final Logger log = Logger.getLogger(PushConsumer.class);
    private PushRegistration registration;
    protected ClientSessionFactory factory;
    protected ClientSession session;
    protected ClientConsumer consumer;
    protected String destination;
    protected String id;
    protected PushStrategy strategy;

    public PushConsumer(ClientSessionFactory factory, String destination, String id, PushRegistration registration) {
        this.factory = factory;
        this.destination = destination;
        this.id = id;
        this.registration = registration;
    }

    public PushRegistration getRegistration() {
        return this.registration;
    }

    public String getDestination() {
        return this.destination;
    }

    public void start() throws Exception {
        if (this.registration.getTarget().getClassName() != null) {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(this.registration.getTarget().getClassName());
            this.strategy = (PushStrategy)clazz.newInstance();
        } else if (this.registration.getTarget().getRelationship() != null) {
            if (this.registration.getTarget().getRelationship().equals("destination")) {
                this.strategy = new HornetQPushStrategy();
            } else if (this.registration.getTarget().getRelationship().equals("template")) {
                this.strategy = new UriTemplateStrategy();
            }
        }
        if (this.strategy == null) {
            this.strategy = new UriStrategy();
        }
        this.strategy.setRegistration(this.registration);
        this.strategy.start();
        this.session = this.factory.createSession(false, false);
        this.consumer = this.registration.getSelector() != null ? this.session.createConsumer(this.destination, SelectorTranslator.convertToHornetQFilterString((String)this.registration.getSelector())) : this.session.createConsumer(this.destination);
        this.consumer.setMessageHandler((MessageHandler)this);
        this.session.start();
        log.info((Object)("Push consumer started for: " + this.registration.getTarget()));
    }

    public void stop() {
        try {
            if (this.consumer != null) {
                this.consumer.close();
            }
        }
        catch (HornetQException e) {
            // empty catch block
        }
        try {
            if (this.session != null) {
                this.session.close();
            }
        }
        catch (HornetQException e) {
            // empty catch block
        }
        try {
            if (this.strategy != null) {
                this.strategy.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onMessage(ClientMessage clientMessage) {
        if (!this.strategy.push(clientMessage)) {
            throw new RuntimeException("Failed to push message to " + this.registration.getTarget());
        }
        try {
            log.debug((Object)("Acknowledging: " + clientMessage.getMessageID()));
            clientMessage.acknowledge();
        }
        catch (HornetQException e) {
            throw new RuntimeException(e);
        }
    }
}

