/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue.push;

import javax.ws.rs.core.UriBuilder;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.core.logging.Logger;
import org.hornetq.rest.queue.push.PushStrategy;
import org.hornetq.rest.queue.push.xml.BasicAuth;
import org.hornetq.rest.queue.push.xml.PushRegistration;
import org.hornetq.rest.queue.push.xml.XmlHttpHeader;
import org.hornetq.rest.util.HttpMessageHelper;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.core.executors.ApacheHttpClientExecutor;
import org.jboss.resteasy.specimpl.UriBuilderImpl;

public class UriStrategy
implements PushStrategy {
    private static final Logger log = Logger.getLogger(UriStrategy.class);
    protected HttpClient client = new HttpClient();
    protected ApacheHttpClientExecutor executor = new ApacheHttpClientExecutor(this.client);
    protected PushRegistration registration;
    protected UriBuilder targetUri;
    protected String method;
    protected String contentType;

    @Override
    public void setRegistration(PushRegistration reg) {
        this.registration = reg;
    }

    @Override
    public void start() throws Exception {
        this.initAuthentication();
        this.method = this.registration.getTarget().getMethod();
        if (this.method == null) {
            this.method = "POST";
        }
        this.contentType = this.registration.getTarget().getType();
        this.targetUri = UriBuilderImpl.fromTemplate((String)this.registration.getTarget().getHref());
    }

    protected void initAuthentication() {
        if (this.registration.getAuthenticationMechanism() != null && this.registration.getAuthenticationMechanism().getType() instanceof BasicAuth) {
            BasicAuth basic = (BasicAuth)this.registration.getAuthenticationMechanism().getType();
            this.client.getParams().setAuthenticationPreemptive(true);
            this.client.getState().setCredentials(new AuthScope(AuthScope.ANY), (Credentials)new UsernamePasswordCredentials(basic.getUsername(), basic.getPassword()));
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean push(ClientMessage message) {
        String uri = this.createUri(message);
        for (int i = 0; i < 3; ++i) {
            int wait = 0;
            ClientRequest request = this.executor.createRequest(uri);
            request.followRedirects(false);
            for (XmlHttpHeader header : this.registration.getHeaders()) {
                request.header(header.getName(), (Object)header.getValue());
            }
            HttpMessageHelper.buildMessage(message, request, this.contentType);
            ClientResponse res = null;
            try {
                log.debug((Object)(this.method + " " + uri));
                res = request.httpMethod(this.method);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (res.getStatus() == 503) {
                String retryAfter = (String)res.getHeaders().getFirst((Object)"Retry-After");
                if (retryAfter == null) continue;
                wait = Integer.parseInt(retryAfter);
                continue;
            }
            if (res.getStatus() == 307) {
                uri = res.getLocation().getHref();
                continue;
            }
            if (res.getStatus() >= 200 && res.getStatus() < 299 || res.getStatus() == 303 || res.getStatus() == 304) {
                log.debug((Object)"Success");
                return true;
            }
            throw new RuntimeException("failed to push message to: " + uri + " status code: " + res.getStatus());
        }
        return false;
    }

    protected String createUri(ClientMessage message) {
        String uri = this.targetUri.build(new Object[0]).toString();
        return uri;
    }
}

