/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.integration;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.hornetq.jms.server.embedded.EmbeddedJMS;
import org.hornetq.rest.integration.ServletContextBindingRegistry;
import org.hornetq.spi.core.naming.BindingRegistry;

public class HornetqBootstrapListener
implements ServletContextListener {
    private EmbeddedJMS jms;

    public void contextInitialized(ServletContextEvent contextEvent) {
        ServletContext context = contextEvent.getServletContext();
        this.jms = new EmbeddedJMS();
        this.jms.setRegistry((BindingRegistry)new ServletContextBindingRegistry(context));
        try {
            this.jms.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        try {
            if (this.jms != null) {
                this.jms.stop();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

