/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue;

import java.net.URI;
import javax.ws.rs.POST;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientProducer;
import org.hornetq.rest.queue.PostMessage;

public class PostMessageDupsOk
extends PostMessage {
    public void publish(HttpHeaders headers, byte[] body, boolean durable, Long ttl, Long expiration, Integer priority) throws Exception {
        PostMessage.Pooled pooled = this.getPooled();
        try {
            ClientProducer producer = pooled.producer;
            ClientMessage message = this.createHornetQMessage(headers, body, durable, ttl, expiration, priority, pooled.session);
            producer.send((Message)message);
            this.pool.add(pooled);
        }
        catch (Exception ex) {
            try {
                pooled.session.close();
            }
            catch (HornetQException e) {
                // empty catch block
            }
            this.addPooled();
            throw ex;
        }
    }

    @POST
    public Response create(@Context HttpHeaders headers, @QueryParam(value="durable") Boolean durable, @QueryParam(value="ttl") Long ttl, @QueryParam(value="expiration") Long expiration, @QueryParam(value="priority") Integer priority, @Context UriInfo uriInfo, byte[] body) {
        try {
            boolean isDurable = this.defaultDurable;
            if (durable != null) {
                isDurable = durable;
            }
            this.publish(headers, body, isDurable, ttl, expiration, priority);
        }
        catch (Exception e) {
            Response error = Response.serverError().entity((Object)("Problem posting message: " + e.getMessage())).type("text/plain").build();
            throw new WebApplicationException((Throwable)e, error);
        }
        Response.ResponseBuilder builder = Response.status((int)201);
        UriBuilder nextBuilder = uriInfo.getAbsolutePathBuilder();
        URI next = nextBuilder.build(new Object[0]);
        this.serviceManager.getLinkStrategy().setLinkHeader(builder, "create-next", "create-next", next.toString(), "*/*");
        return builder.build();
    }
}

