/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue;

import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.core.logging.Logger;
import org.hornetq.rest.queue.AcknowledgedQueueConsumer;
import org.hornetq.rest.queue.Acknowledgement;
import org.hornetq.rest.queue.DestinationServiceManager;
import org.hornetq.rest.queue.QueueConsumer;
import org.hornetq.rest.util.TimeoutTask;

public class ConsumersResource
implements TimeoutTask.Callback {
    private static final Logger log = Logger.getLogger(ConsumersResource.class);
    protected ConcurrentHashMap<String, QueueConsumer> queueConsumers = new ConcurrentHashMap();
    protected ClientSessionFactory sessionFactory;
    protected String destination;
    protected final String startup = Long.toString(System.currentTimeMillis());
    protected AtomicLong sessionCounter = new AtomicLong(1L);
    protected int consumerTimeoutSeconds;
    protected DestinationServiceManager serviceManager;
    protected static final int ACKNOWLEDGED = 1;
    protected static final int SELECTOR_SET = 2;

    public DestinationServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void setServiceManager(DestinationServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public ClientSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(ClientSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public int getConsumerTimeoutSeconds() {
        return this.consumerTimeoutSeconds;
    }

    public void setConsumerTimeoutSeconds(int consumerTimeoutSeconds) {
        this.consumerTimeoutSeconds = consumerTimeoutSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testTimeout(String target) {
        QueueConsumer consumer = this.queueConsumers.get(target);
        if (consumer == null) {
            return;
        }
        QueueConsumer queueConsumer = consumer;
        synchronized (queueConsumer) {
            if (System.currentTimeMillis() - consumer.getLastPingTime() > (long)(this.consumerTimeoutSeconds * 1000)) {
                log.warn((Object)("shutdown REST consumer because of timeout for: " + consumer.getId()));
                consumer.shutdown();
                this.queueConsumers.remove(consumer.getId());
                this.serviceManager.getTimeoutTask().remove(consumer.getId());
            }
        }
    }

    public void stop() {
        for (QueueConsumer consumer : this.queueConsumers.values()) {
            consumer.shutdown();
        }
    }

    @POST
    public Response createSubscription(@FormParam(value="autoAck") @DefaultValue(value="true") boolean autoAck, @FormParam(value="selector") String selector, @Context UriInfo uriInfo) {
        try {
            QueueConsumer consumer = null;
            int attributes = 0;
            if (selector != null) {
                attributes |= 2;
            }
            if (autoAck) {
                consumer = this.createConsumer(selector);
            } else {
                attributes |= 1;
                consumer = this.createAcknowledgedConsumer(selector);
            }
            String attributesSegment = "attributes-" + attributes;
            UriBuilder location = uriInfo.getAbsolutePathBuilder();
            location.path(attributesSegment);
            location.path(consumer.getId());
            Response.ResponseBuilder builder = Response.created((URI)location.build(new Object[0]));
            if (autoAck) {
                QueueConsumer.setConsumeNextLink(this.serviceManager.getLinkStrategy(), builder, uriInfo, (String)uriInfo.getMatchedURIs().get(1) + "/" + attributesSegment + "/" + consumer.getId(), "-1");
            } else {
                AcknowledgedQueueConsumer.setAcknowledgeNextLink(this.serviceManager.getLinkStrategy(), builder, uriInfo, (String)uriInfo.getMatchedURIs().get(1) + "/" + attributesSegment + "/" + consumer.getId(), "-1");
            }
            Response response = builder.build();
            return response;
        }
        catch (HornetQException e) {
            throw new RuntimeException(e);
        }
    }

    protected void addConsumer(QueueConsumer consumer) {
        this.queueConsumers.put(consumer.getId(), consumer);
        this.serviceManager.getTimeoutTask().add(this, consumer.getId());
    }

    public QueueConsumer createConsumer(String selector) throws HornetQException {
        String genId = this.sessionCounter.getAndIncrement() + "-queue-" + this.destination + "-" + this.startup;
        QueueConsumer consumer = new QueueConsumer(this.sessionFactory, this.destination, genId, this.serviceManager, selector);
        this.addConsumer(consumer);
        return consumer;
    }

    public QueueConsumer createAcknowledgedConsumer(String selector) throws HornetQException {
        String genId = this.sessionCounter.getAndIncrement() + "-queue-" + this.destination + "-" + this.startup;
        AcknowledgedQueueConsumer consumer = new AcknowledgedQueueConsumer(this.sessionFactory, this.destination, genId, this.serviceManager, selector);
        this.addConsumer(consumer);
        return consumer;
    }

    @Path(value="attributes-{attributes}/{consumer-id}")
    @GET
    public Response getConsumer(@PathParam(value="attributes") int attributes, @PathParam(value="consumer-id") String consumerId, @Context UriInfo uriInfo) throws Exception {
        return this.headConsumer(attributes, consumerId, uriInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Path(value="attributes-{attributes}/{consumer-id}")
    @HEAD
    public Response headConsumer(@PathParam(value="attributes") int attributes, @PathParam(value="consumer-id") String consumerId, @Context UriInfo uriInfo) throws Exception {
        QueueConsumer consumer = this.findConsumer(attributes, consumerId, uriInfo);
        Response.ResponseBuilder builder = Response.noContent();
        QueueConsumer queueConsumer = consumer;
        synchronized (queueConsumer) {
            if ((attributes & 1) > 0) {
                AcknowledgedQueueConsumer ackedConsumer = (AcknowledgedQueueConsumer)consumer;
                Acknowledgement ack = ackedConsumer.getAck();
                if (ack == null || ack.wasSet()) {
                    AcknowledgedQueueConsumer.setAcknowledgeNextLink(this.serviceManager.getLinkStrategy(), builder, uriInfo, (String)uriInfo.getMatchedURIs().get(1) + "/attributes-" + attributes + "/" + consumer.getId(), Long.toString(consumer.getConsumeIndex()));
                } else {
                    ackedConsumer.setAcknowledgementLink(builder, uriInfo, (String)uriInfo.getMatchedURIs().get(1) + "/attributes-" + attributes + "/" + consumer.getId());
                }
            } else {
                QueueConsumer.setConsumeNextLink(this.serviceManager.getLinkStrategy(), builder, uriInfo, (String)uriInfo.getMatchedURIs().get(1) + "/attributes-" + attributes + "/" + consumer.getId(), Long.toString(consumer.getConsumeIndex()));
            }
        }
        return builder.build();
    }

    @Path(value="attributes-{attributes}/{consumer-id}")
    public QueueConsumer findConsumer(@PathParam(value="attributes") int attributes, @PathParam(value="consumer-id") String consumerId, @Context UriInfo uriInfo) throws Exception {
        QueueConsumer consumer = this.queueConsumers.get(consumerId);
        if (consumer == null) {
            if ((attributes & 2) > 0) {
                Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.GONE).entity((Object)"Cannot reconnect to selector-based consumer.  You must recreate the consumer session.").type("text/plain");
                UriBuilder uriBuilder = uriInfo.getBaseUriBuilder();
                uriBuilder.path((String)uriInfo.getMatchedURIs().get(1));
                this.serviceManager.getLinkStrategy().setLinkHeader(builder, "pull-consumers", "pull-consumers", uriBuilder.build(new Object[0]).toString(), null);
                throw new WebApplicationException(builder.build());
            }
            if ((attributes & 1) > 0) {
                AcknowledgedQueueConsumer tmp = new AcknowledgedQueueConsumer(this.sessionFactory, this.destination, consumerId, this.serviceManager, null);
                consumer = this.addReconnectedConsumerToMap(consumerId, tmp);
            } else {
                QueueConsumer tmp = new QueueConsumer(this.sessionFactory, this.destination, consumerId, this.serviceManager, null);
                consumer = this.addReconnectedConsumerToMap(consumerId, tmp);
            }
        }
        return consumer;
    }

    private QueueConsumer addReconnectedConsumerToMap(String consumerId, QueueConsumer tmp) {
        QueueConsumer consumer = this.queueConsumers.putIfAbsent(consumerId, tmp);
        if (consumer != null) {
            tmp.shutdown();
        } else {
            consumer = tmp;
            this.serviceManager.getTimeoutTask().add(this, consumer.getId());
        }
        return consumer;
    }

    @Path(value="attributes-{attributes}/{consumer-id}")
    @DELETE
    public void closeSession(@PathParam(value="consumer-id") String consumerId) {
        QueueConsumer consumer = this.queueConsumers.remove(consumerId);
        if (consumer == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Failed to match a consumer to URL" + consumerId)).type("text/plain").build());
        }
        consumer.shutdown();
    }
}

