/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.util;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.List;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.rest.HttpHeaderProperty;
import org.jboss.resteasy.client.ClientRequest;

public class HttpMessageHelper {
    public static final String POSTED_AS_HTTP_MESSAGE = "postedAsHttpMessage";

    public static boolean isTransferableHttpHeader(String key) {
        String lowerKey = key.toLowerCase();
        return lowerKey.toLowerCase().startsWith("content") || lowerKey.toLowerCase().equals("link");
    }

    public static void buildMessage(ClientMessage message, Response.ResponseBuilder builder) {
        for (SimpleString key : message.getPropertyNames()) {
            String k = key.toString();
            String headerName = HttpHeaderProperty.fromPropertyName(k);
            if (headerName == null) continue;
            builder.header(headerName, (Object)message.getStringProperty(k));
        }
        int size = message.getBodySize();
        if (size > 0) {
            byte[] body = new byte[size];
            message.getBodyBuffer().readBytes(body);
            Boolean aBoolean = message.getBooleanProperty(POSTED_AS_HTTP_MESSAGE);
            if (aBoolean != null && aBoolean.booleanValue()) {
                builder.entity((Object)body);
            } else {
                ByteArrayInputStream bais = new ByteArrayInputStream(body);
                Object obj = null;
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    obj = ois.readObject();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                builder.entity(obj);
            }
        }
    }

    public static void buildMessage(ClientMessage message, ClientRequest request, String contentType) {
        for (SimpleString key : message.getPropertyNames()) {
            String k = key.toString();
            String headerName = HttpHeaderProperty.fromPropertyName(k);
            if (headerName == null) continue;
            String value = message.getStringProperty(k);
            request.header(headerName, (Object)value);
            if (!headerName.equalsIgnoreCase("content-type")) continue;
            contentType = value;
        }
        int size = message.getBodySize();
        if (size > 0) {
            byte[] body;
            Boolean aBoolean = message.getBooleanProperty(POSTED_AS_HTTP_MESSAGE);
            if (aBoolean != null && aBoolean.booleanValue()) {
                body = new byte[size];
                message.getBodyBuffer().readBytes(body);
                request.body(contentType, (Object)body);
            } else {
                size = message.getBodyBuffer().readInt();
                body = new byte[size];
                message.getBodyBuffer().readBytes(body);
                ByteArrayInputStream bais = new ByteArrayInputStream(body);
                Object obj = null;
                try {
                    ObjectInputStream ois = new ObjectInputStream(bais);
                    obj = ois.readObject();
                    request.body(contentType, obj);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public static void writeHttpMessage(HttpHeaders headers, byte[] body, ClientMessage message) throws Exception {
        MultivaluedMap hdrs = headers.getRequestHeaders();
        for (String key : hdrs.keySet()) {
            if (!HttpMessageHelper.isTransferableHttpHeader(key)) continue;
            List vals = (List)hdrs.get((Object)key);
            String value = HttpMessageHelper.concatenateHeaderValue(vals);
            message.putStringProperty(HttpHeaderProperty.toPropertyName(key), value);
        }
        message.putBooleanProperty(POSTED_AS_HTTP_MESSAGE, true);
        message.getBodyBuffer().writeBytes(body);
    }

    public static String concatenateHeaderValue(List<String> vals) {
        if (vals == null) {
            return "";
        }
        StringBuffer val = null;
        for (String v : vals) {
            if (val == null) {
                val = new StringBuffer(v);
                continue;
            }
            val.append(",").append(v);
        }
        String value = "";
        if (val != null) {
            value = val.toString();
        }
        return value;
    }
}

