/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest;

import org.hornetq.api.core.HornetQException;
import org.hornetq.rest.queue.push.xml.XmlLink;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Cause;
import org.jboss.logging.LogMessage;
import org.jboss.logging.Logger;
import org.jboss.logging.Message;
import org.jboss.logging.MessageLogger;

@MessageLogger(projectCode="HQ")
public interface HornetQRestLogger
extends BasicLogger {
    public static final HornetQRestLogger LOGGER = (HornetQRestLogger)Logger.getMessageLogger(HornetQRestLogger.class, (String)HornetQRestLogger.class.getPackage().getName());

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=181001, value="Loading REST push store from: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void loadingRestStore(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=181002, value="adding REST push registration: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void addingPushRegistration(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=181003, value="Push consumer started for: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void startingPushConsumer(XmlLink var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=182001, value="shutdown REST consumer because of timeout for: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void shutdownRestConsumer(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=182002, value="shutdown REST subscription because of timeout for: {0}", format=Message.Format.MESSAGE_FORMAT)
    public void shutdownRestSubscription(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=184001, value="Failed to load push store {0}, it is probably corrupted", format=Message.Format.MESSAGE_FORMAT)
    public void errorLoadingStore(@Cause Exception var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=184002, value="Error updating store", format=Message.Format.MESSAGE_FORMAT)
    public void errorUpdatingStore(@Cause Exception var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=184003, value="Failed to push message to {0} disabling push registration...", format=Message.Format.MESSAGE_FORMAT)
    public void errorPushingMessage(XmlLink var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=184004, value="Error deleting Subscriber queue", format=Message.Format.MESSAGE_FORMAT)
    public void errorDeletingSubscriberQueue(@Cause HornetQException var1);
}

