/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue;

import java.net.URI;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.rest.queue.Acknowledgement;
import org.hornetq.rest.queue.DestinationServiceManager;
import org.hornetq.rest.queue.QueueConsumer;
import org.hornetq.rest.util.LinkStrategy;

public class AcknowledgedQueueConsumer
extends QueueConsumer {
    protected long counter;
    protected String startup = Long.toString(System.currentTimeMillis());
    protected volatile Acknowledgement ack;

    public AcknowledgedQueueConsumer(ClientSessionFactory factory, String destination, String id, DestinationServiceManager serviceManager, String selector) throws HornetQException {
        super(factory, destination, id, serviceManager, selector);
        this.autoAck = false;
    }

    public synchronized Acknowledgement getAck() {
        return this.ack;
    }

    @Override
    @Path(value="acknowledge-next{index}")
    @POST
    public synchronized Response poll(@HeaderParam(value="Accept-Wait") @DefaultValue(value="0") long wait, @PathParam(value="index") long index, @Context UriInfo info) {
        if (this.closed) {
            UriBuilder builder = info.getBaseUriBuilder();
            String path = (String)info.getMatchedURIs().get(1);
            builder.path(path).path("acknowledge-next");
            String uri = builder.build(new Object[0]).toString();
            return Response.status((int)307).location(URI.create(uri)).build();
        }
        return this.checkIndexAndPoll(wait, info, (String)info.getMatchedURIs().get(1), index);
    }

    @Override
    public synchronized void shutdown() {
        super.shutdown();
        if (this.ack != null) {
            this.ack = null;
        }
    }

    @Path(value="acknowledgement/{ackToken}")
    @POST
    public synchronized Response acknowledge(@PathParam(value="ackToken") String ackToken, @FormParam(value="acknowledge") boolean doAcknowledge, @Context UriInfo uriInfo) {
        this.ping();
        String basePath = (String)uriInfo.getMatchedURIs().get(1);
        if (this.closed) {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"Could not acknowledge message, it was probably requeued from a timeout").type("text/plain");
            this.setAcknowledgeLinks(uriInfo, basePath, builder, "-1");
            return builder.build();
        }
        if (this.ack == null || !this.ack.getAckToken().equals(ackToken)) {
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)"Could not acknowledge message, it was probably requeued from a timeout or you have an old link").type("text/plain");
            this.setAcknowledgeLinks(uriInfo, basePath, builder, "-1");
            return builder.build();
        }
        this.previousIndex = -2L;
        this.lastConsumed = null;
        if (this.ack.wasSet() && doAcknowledge != this.ack.isAcknowledged()) {
            StringBuilder msg = new StringBuilder("Could not ");
            if (!doAcknowledge) {
                msg.append("un");
            }
            msg.append("acknowledge message because it has already been ");
            if (doAcknowledge) {
                msg.append("un");
            }
            msg.append("acknowledged");
            Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)msg.toString()).type("text/plain");
            this.setAcknowledgeLinks(uriInfo, basePath, builder, "-1");
            return builder.build();
        }
        if (this.ack.wasSet() && doAcknowledge == this.ack.isAcknowledged()) {
            Response.ResponseBuilder builder = Response.noContent();
            this.setAcknowledgeLinks(uriInfo, basePath, builder, "-1");
            return builder.build();
        }
        if (doAcknowledge) {
            try {
                this.ack.acknowledge();
                this.ack.getMessage().acknowledge();
            }
            catch (HornetQException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.ack.unacknowledge();
            this.unacknowledge();
        }
        Response.ResponseBuilder builder = Response.noContent();
        this.setAcknowledgeLinks(uriInfo, basePath, builder, "-1");
        return builder.build();
    }

    @Override
    protected ClientMessage receive(long timeoutSecs) throws Exception {
        ClientMessage msg = super.receive(timeoutSecs);
        return msg;
    }

    @Override
    protected ClientMessage receiveFromConsumer(long timeoutSecs) throws Exception {
        ClientMessage message = super.receiveFromConsumer(timeoutSecs);
        if (message != null) {
            this.ack = new Acknowledgement(this.counter++ + this.startup, message);
        }
        return message;
    }

    protected String getAckToken() {
        return this.ack.getAckToken();
    }

    protected void unacknowledge() {
        ClientConsumer old = this.consumer;
        ClientSession oldSession = this.session;
        try {
            this.createSession();
        }
        catch (Exception e) {
            this.shutdown();
            throw new RuntimeException(e);
        }
        finally {
            try {
                old.close();
            }
            catch (HornetQException e) {}
            try {
                oldSession.close();
            }
            catch (HornetQException e) {}
        }
    }

    protected void setAcknowledgeLinks(UriInfo uriInfo, String basePath, Response.ResponseBuilder builder, String index) {
        AcknowledgedQueueConsumer.setAcknowledgeNextLink(this.serviceManager.getLinkStrategy(), builder, uriInfo, basePath, index);
        this.setSessionLink(builder, uriInfo, basePath);
    }

    @Override
    protected void setMessageResponseLinks(UriInfo info, String basePath, Response.ResponseBuilder builder, String index) {
        this.setAcknowledgementLink(builder, info, basePath);
        this.setSessionLink(builder, info, basePath);
    }

    @Override
    protected void setPollTimeoutLinks(UriInfo info, String basePath, Response.ResponseBuilder builder, String index) {
        AcknowledgedQueueConsumer.setAcknowledgeNextLink(this.serviceManager.getLinkStrategy(), builder, info, basePath, index);
        this.setSessionLink(builder, info, basePath);
    }

    public void setAcknowledgementLink(Response.ResponseBuilder response, UriInfo info, String basePath) {
        UriBuilder builder = info.getBaseUriBuilder();
        builder.path(basePath).path("acknowledgement").path(this.getAckToken());
        String uri = builder.build(new Object[0]).toString();
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "acknowledgement", "acknowledgement", uri, "application/x-www-form-urlencoded");
    }

    public static void setAcknowledgeNextLink(LinkStrategy linkStrategy, Response.ResponseBuilder response, UriInfo info, String basePath, String index) {
        if (index == null) {
            throw new IllegalArgumentException("index cannot be null");
        }
        UriBuilder builder = info.getBaseUriBuilder();
        builder.path(basePath).path("acknowledge-next" + index);
        String uri = builder.build(new Object[0]).toString();
        linkStrategy.setLinkHeader(response, "acknowledge-next", "acknowledge-next", uri, "application/x-www-form-urlencoded");
    }
}

