/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import javax.ws.rs.core.Response;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.rest.queue.ConsumedMessage;

public class ConsumedObjectMessage
extends ConsumedMessage {
    protected Object readObject;

    public ConsumedObjectMessage(ClientMessage message) {
        super(message);
        if (message.getType() != 2) {
            throw new IllegalArgumentException("Client message must be an OBJECT_TYPE");
        }
    }

    @Override
    public void build(Response.ResponseBuilder builder) {
        int size;
        this.buildHeaders(builder);
        if (this.readObject == null && (size = this.message.getBodyBuffer().readInt()) > 0) {
            byte[] body = new byte[size];
            this.message.getBodyBuffer().readBytes(body);
            ByteArrayInputStream bais = new ByteArrayInputStream(body);
            try {
                ObjectInputStream ois = new ObjectInputStream(bais);
                this.readObject = ois.readObject();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        builder.entity(this.readObject);
    }
}

