/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue;

import java.util.ArrayList;
import java.util.List;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.rest.queue.DestinationServiceManager;
import org.hornetq.rest.queue.QueueDeployment;
import org.hornetq.rest.queue.QueueDestinationsResource;
import org.hornetq.rest.queue.QueueResource;
import org.hornetq.rest.queue.push.FilePushStore;
import org.hornetq.rest.queue.push.PushStore;

public class QueueServiceManager
extends DestinationServiceManager {
    protected PushStore pushStore;
    protected List<QueueDeployment> queues = new ArrayList<QueueDeployment>();
    protected QueueDestinationsResource destination;

    public List<QueueDeployment> getQueues() {
        return this.queues;
    }

    public void setQueues(List<QueueDeployment> queues) {
        this.queues = queues;
    }

    public PushStore getPushStore() {
        return this.pushStore;
    }

    public void setPushStore(PushStore pushStore) {
        this.pushStore = pushStore;
    }

    public QueueDestinationsResource getDestination() {
        return this.destination;
    }

    public void setDestination(QueueDestinationsResource destination) {
        this.destination = destination;
    }

    @Override
    public void start() throws Exception {
        this.initDefaults();
        this.destination = new QueueDestinationsResource(this);
        this.started = true;
        if (this.pushStoreFile != null && this.pushStore == null) {
            this.pushStore = new FilePushStore(this.pushStoreFile);
        }
        for (QueueDeployment queueDeployment : this.queues) {
            this.deploy(queueDeployment);
        }
    }

    public void deploy(QueueDeployment queueDeployment) throws Exception {
        if (!this.started) {
            throw new Exception("You must start() this class instance before deploying");
        }
        String queueName = queueDeployment.getName();
        ClientSession session = this.sessionFactory.createSession(false, false, false);
        ClientSession.QueueQuery query = session.queueQuery(new SimpleString(queueName));
        if (!query.isExists()) {
            session.createQueue(queueName, queueName, queueDeployment.isDurableSend());
        }
        session.close();
        this.destination.createQueueResource(queueName, queueDeployment.isDurableSend(), queueDeployment.getConsumerSessionTimeoutSeconds(), queueDeployment.isDuplicatesAllowed());
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        for (QueueResource queue : this.destination.getQueues().values()) {
            queue.stop();
        }
        try {
            this.timeoutTask.stop();
            this.sessionFactory.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

