/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.topic;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.api.core.client.ClientSessionFactory;
import org.hornetq.rest.HornetQRestLogger;
import org.hornetq.rest.queue.push.PushConsumer;
import org.hornetq.rest.topic.PushSubscription;
import org.hornetq.rest.topic.PushTopicRegistration;
import org.hornetq.rest.topic.TopicPushStore;

public class PushSubscriptionsResource {
    protected Map<String, PushSubscription> consumers = new ConcurrentHashMap<String, PushSubscription>();
    protected ClientSessionFactory sessionFactory;
    protected String destination;
    protected final String startup = Long.toString(System.currentTimeMillis());
    protected final AtomicLong sessionCounter = new AtomicLong(1L);
    protected TopicPushStore pushStore;

    public void stop() {
        for (PushConsumer pushConsumer : this.consumers.values()) {
            pushConsumer.stop();
            if (pushConsumer.getRegistration().isDurable()) continue;
            this.deleteSubscriberQueue(pushConsumer);
        }
    }

    public TopicPushStore getPushStore() {
        return this.pushStore;
    }

    public void setPushStore(TopicPushStore pushStore) {
        this.pushStore = pushStore;
    }

    public ClientSession createSubscription(String subscriptionName, boolean durable) {
        ClientSession session = null;
        try {
            session = this.sessionFactory.createSession();
            if (durable) {
                session.createQueue(this.destination, subscriptionName, true);
            } else {
                session.createTemporaryQueue(this.destination, subscriptionName);
            }
            return session;
        }
        catch (HornetQException e) {
            throw new RuntimeException(e);
        }
    }

    public void addRegistration(PushTopicRegistration reg) throws Exception {
        if (!reg.isEnabled()) {
            return;
        }
        String destination = reg.getDestination();
        ClientSession session = this.sessionFactory.createSession(false, false, false);
        ClientSession.QueueQuery query = session.queueQuery(new SimpleString(destination));
        ClientSession createSession = null;
        if (!query.isExists()) {
            createSession = this.createSubscription(destination, reg.isDurable());
        }
        PushSubscription consumer = new PushSubscription(this.sessionFactory, reg.getDestination(), reg.getId(), reg, this.pushStore);
        try {
            consumer.start();
        }
        catch (Exception e) {
            consumer.stop();
            throw new Exception("Failed starting push subscriber for " + destination + " of push subscriber: " + reg.getTarget(), e);
        }
        finally {
            this.closeSession(createSession);
            this.closeSession(session);
        }
        this.consumers.put(reg.getId(), consumer);
    }

    private void closeSession(ClientSession createSession) {
        if (createSession != null) {
            try {
                createSession.close();
            }
            catch (HornetQException hornetQException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    public Response create(@Context UriInfo uriInfo, PushTopicRegistration registration) {
        HornetQRestLogger.LOGGER.debug("Handling POST request for \"" + uriInfo.getPath() + "\"");
        String genId = this.sessionCounter.getAndIncrement() + "-topic-" + this.destination + "-" + this.startup;
        if (registration.getDestination() == null) {
            registration.setDestination(genId);
        }
        registration.setId(genId);
        registration.setTopic(this.destination);
        ClientSession createSession = this.createSubscription(genId, registration.isDurable());
        try {
            PushSubscription consumer = new PushSubscription(this.sessionFactory, genId, genId, registration, this.pushStore);
            try {
                consumer.start();
                if (registration.isDurable() && this.pushStore != null) {
                    this.pushStore.add(registration);
                }
            }
            catch (Exception e) {
                consumer.stop();
                throw new WebApplicationException((Throwable)e, Response.serverError().entity((Object)"Failed to start consumer.").type("text/plain").build());
            }
            this.consumers.put(genId, consumer);
            UriBuilder location = uriInfo.getAbsolutePathBuilder();
            location.path(genId);
            Response response = Response.created((URI)location.build(new Object[0])).build();
            return response;
        }
        finally {
            this.closeSession(createSession);
        }
    }

    @GET
    @Path(value="{consumer-id}")
    @Produces(value={"application/xml"})
    public PushTopicRegistration getConsumer(@Context UriInfo uriInfo, @PathParam(value="consumer-id") String consumerId) {
        HornetQRestLogger.LOGGER.debug("Handling GET request for \"" + uriInfo.getPath() + "\"");
        PushConsumer consumer = this.consumers.get(consumerId);
        if (consumer == null) {
            throw new WebApplicationException(Response.status((int)404).entity((Object)"Could not find consumer.").type("text/plain").build());
        }
        return (PushTopicRegistration)consumer.getRegistration();
    }

    @DELETE
    @Path(value="{consumer-id}")
    public void deleteConsumer(@Context UriInfo uriInfo, @PathParam(value="consumer-id") String consumerId) {
        HornetQRestLogger.LOGGER.debug("Handling DELETE request for \"" + uriInfo.getPath() + "\"");
        PushConsumer consumer = this.consumers.remove(consumerId);
        if (consumer == null) {
            throw new WebApplicationException(Response.status((int)404).entity((Object)"Could not find consumer.").type("text/plain").build());
        }
        consumer.stop();
        this.deleteSubscriberQueue(consumer);
    }

    public Map<String, PushSubscription> getConsumers() {
        return this.consumers;
    }

    public ClientSessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(ClientSessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteSubscriberQueue(PushConsumer consumer) {
        String subscriptionName = consumer.getDestination();
        ClientSession session = null;
        try {
            session = this.sessionFactory.createSession();
            session.deleteQueue(subscriptionName);
        }
        catch (HornetQException e) {
        }
        finally {
            this.closeSession(session);
        }
    }
}

