/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class TimeoutTask
implements Runnable {
    protected boolean running = true;
    protected int interval = 10;
    protected Map<String, Callback> callbacks = new HashMap<String, Callback>();
    protected Thread thread;

    public TimeoutTask(int interval) {
        this.interval = interval;
    }

    public synchronized void add(Callback callback, String token) {
        this.callbacks.put(token, callback);
    }

    public synchronized void remove(String token) {
        this.callbacks.remove(token);
    }

    public synchronized void stop() {
        this.running = false;
        this.thread.interrupt();
    }

    public synchronized int getInterval() {
        return this.interval;
    }

    public synchronized void setInterval(int interval) {
        this.interval = interval;
    }

    public void start() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                Thread.sleep(this.interval * 1000);
            }
            catch (InterruptedException e) {
                this.running = false;
                break;
            }
            TimeoutTask timeoutTask = this;
            synchronized (timeoutTask) {
                ArrayList<String> list = new ArrayList<String>(this.callbacks.size());
                for (String token : this.callbacks.keySet()) {
                    list.add(token);
                }
                for (String token : list) {
                    Callback callback = this.callbacks.get(token);
                    callback.testTimeout(token);
                }
            }
        }
    }

    public static interface Callback {
        public void testTimeout(String var1);
    }
}

