/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.topic;

import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.hornetq.api.core.SimpleString;
import org.hornetq.api.core.client.ClientSession;
import org.hornetq.rest.HornetQRestLogger;
import org.hornetq.rest.queue.DestinationResource;
import org.hornetq.rest.queue.PostMessage;
import org.hornetq.rest.topic.PushSubscriptionsResource;
import org.hornetq.rest.topic.SubscriptionsResource;
import org.hornetq.rest.topic.TopicDestinationsResource;

public class TopicResource
extends DestinationResource {
    protected SubscriptionsResource subscriptions;
    protected PushSubscriptionsResource pushSubscriptions;
    private TopicDestinationsResource topicDestinationsResource;

    public void start() throws Exception {
    }

    public void stop() {
        this.subscriptions.stop();
        this.pushSubscriptions.stop();
        this.sender.cleanup();
    }

    @GET
    @Produces(value={"application/xml"})
    public Response get(@Context UriInfo uriInfo) {
        HornetQRestLogger.LOGGER.debug("Handling GET request for \"" + uriInfo.getPath() + "\"");
        StringBuilder msg = new StringBuilder();
        msg.append("<topic>").append("<name>").append(this.destination).append("</name>").append("<atom:link rel=\"create\" href=\"").append(this.createSenderLink(uriInfo)).append("\"/>").append("<atom:link rel=\"create-with-id\" href=\"").append(this.createSenderWithIdLink(uriInfo)).append("\"/>").append("<atom:link rel=\"pull-consumers\" href=\"").append(this.createSubscriptionsLink(uriInfo)).append("\"/>").append("<atom:link rel=\"push-consumers\" href=\"").append(this.createPushSubscriptionsLink(uriInfo)).append("\"/>").append("</topic>");
        Response.ResponseBuilder builder = Response.ok((Object)msg.toString());
        this.setSenderLink(builder, uriInfo);
        this.setSenderWithIdLink(builder, uriInfo);
        this.setSubscriptionsLink(builder, uriInfo);
        this.setPushSubscriptionsLink(builder, uriInfo);
        return builder.build();
    }

    @HEAD
    @Produces(value={"application/xml"})
    public Response head(@Context UriInfo uriInfo) {
        HornetQRestLogger.LOGGER.debug("Handling HEAD request for \"" + uriInfo.getPath() + "\"");
        Response.ResponseBuilder builder = Response.ok();
        this.setSenderLink(builder, uriInfo);
        this.setSenderWithIdLink(builder, uriInfo);
        this.setSubscriptionsLink(builder, uriInfo);
        this.setPushSubscriptionsLink(builder, uriInfo);
        return builder.build();
    }

    protected void setSenderLink(Response.ResponseBuilder response, UriInfo info) {
        String uri = this.createSenderLink(info);
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "create", "create", uri, null);
    }

    protected String createSenderLink(UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("create");
        String uri = builder.build(new Object[0]).toString();
        return uri;
    }

    protected void setSenderWithIdLink(Response.ResponseBuilder response, UriInfo info) {
        String uri = this.createSenderWithIdLink(info);
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "create-with-id", "create-with-id", uri, null);
    }

    protected String createSenderWithIdLink(UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("create");
        String uri = builder.build(new Object[0]).toString();
        uri = uri + "/{id}";
        return uri;
    }

    protected void setSubscriptionsLink(Response.ResponseBuilder response, UriInfo info) {
        String uri = this.createSubscriptionsLink(info);
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "pull-subscriptions", "pull-subscriptions", uri, null);
    }

    protected String createSubscriptionsLink(UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("pull-subscriptions");
        String uri = builder.build(new Object[0]).toString();
        return uri;
    }

    protected void setPushSubscriptionsLink(Response.ResponseBuilder response, UriInfo info) {
        String uri = this.createPushSubscriptionsLink(info);
        this.serviceManager.getLinkStrategy().setLinkHeader(response, "push-subscriptions", "push-subscriptions", uri, null);
    }

    protected String createPushSubscriptionsLink(UriInfo info) {
        UriBuilder builder = info.getRequestUriBuilder();
        builder.path("push-subscriptions");
        String uri = builder.build(new Object[0]).toString();
        return uri;
    }

    public void setSubscriptions(SubscriptionsResource subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Path(value="create")
    public PostMessage post() throws Exception {
        return this.sender;
    }

    @Path(value="pull-subscriptions")
    public SubscriptionsResource getSubscriptions() {
        return this.subscriptions;
    }

    @Path(value="push-subscriptions")
    public PushSubscriptionsResource getPushSubscriptions() {
        return this.pushSubscriptions;
    }

    public void setPushSubscriptions(PushSubscriptionsResource pushSubscriptions) {
        this.pushSubscriptions = pushSubscriptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    public void deleteTopic(@Context UriInfo uriInfo) throws Exception {
        HornetQRestLogger.LOGGER.debug("Handling DELETE request for \"" + uriInfo.getPath() + "\"");
        this.topicDestinationsResource.getTopics().remove(this.destination);
        try {
            this.stop();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        ClientSession session = this.serviceManager.getSessionFactory().createSession(false, false, false);
        try {
            SimpleString topicName = new SimpleString(this.destination);
            session.deleteQueue(topicName);
        }
        finally {
            try {
                session.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setTopicDestinationsResource(TopicDestinationsResource topicDestinationsResource) {
        this.topicDestinationsResource = topicDestinationsResource;
    }
}

