/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.queue;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.Response;
import org.hornetq.api.core.client.ClientMessage;
import org.hornetq.jms.client.ConnectionFactoryOptions;
import org.hornetq.rest.queue.ConsumedMessage;
import org.hornetq.utils.ObjectInputStreamWithClassLoader;

public class ConsumedObjectMessage
extends ConsumedMessage {
    protected Object readObject;
    private ConnectionFactoryOptions options;

    public ConsumedObjectMessage(ClientMessage message, ConnectionFactoryOptions options) {
        super(message);
        if (message.getType() != 2) {
            throw new IllegalArgumentException("Client message must be an OBJECT_TYPE");
        }
        this.options = options;
    }

    @Override
    public void build(Response.ResponseBuilder builder) {
        int size;
        this.buildHeaders(builder);
        if (this.readObject == null && (size = this.message.getBodyBuffer().readInt()) > 0) {
            byte[] body = new byte[size];
            this.message.getBodyBuffer().readBytes(body);
            ByteArrayInputStream bais = new ByteArrayInputStream(body);
            try {
                ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader((InputStream)bais);
                if (this.options != null) {
                    ois.setWhiteList(this.options.getDeserializationWhiteList());
                    ois.setBlackList(this.options.getDeserializationBlackList());
                }
                this.readObject = ois.readObject();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        builder.entity(this.readObject);
    }
}

