/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.rest.integration;

import org.hornetq.core.server.embedded.EmbeddedHornetQ;
import org.hornetq.jms.client.ConnectionFactoryOptions;
import org.hornetq.rest.MessageServiceManager;
import org.jboss.resteasy.plugins.server.tjws.TJWSEmbeddedJaxrsServer;
import org.jboss.resteasy.test.TestPortProvider;

public class EmbeddedRestHornetQ {
    protected TJWSEmbeddedJaxrsServer tjws = new TJWSEmbeddedJaxrsServer();
    protected EmbeddedHornetQ embeddedHornetQ;
    protected MessageServiceManager manager = new MessageServiceManager(null);

    public EmbeddedRestHornetQ(ConnectionFactoryOptions jmsOptions) {
        int port = TestPortProvider.getPort();
        this.tjws.setPort(port);
        this.tjws.setRootResourcePath("");
        this.tjws.setSecurityDomain(null);
        this.manager = new MessageServiceManager(jmsOptions);
        this.initEmbeddedHornetQ();
    }

    protected void initEmbeddedHornetQ() {
        this.embeddedHornetQ = new EmbeddedHornetQ();
    }

    public TJWSEmbeddedJaxrsServer getTjws() {
        return this.tjws;
    }

    public void setTjws(TJWSEmbeddedJaxrsServer tjws) {
        this.tjws = tjws;
    }

    public EmbeddedHornetQ getEmbeddedHornetQ() {
        return this.embeddedHornetQ;
    }

    public MessageServiceManager getManager() {
        return this.manager;
    }

    public void start() throws Exception {
        this.embeddedHornetQ.start();
        this.tjws.start();
        this.manager.start();
        this.tjws.getDeployment().getRegistry().addSingletonResource((Object)this.manager.getQueueManager().getDestination());
        this.tjws.getDeployment().getRegistry().addSingletonResource((Object)this.manager.getTopicManager().getDestination());
    }

    public void stop() throws Exception {
        try {
            this.tjws.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.manager.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.embeddedHornetQ.stop();
    }
}

