/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.config;

import java.io.Serializable;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.UUIDGenerator;

public class DivertConfiguration
implements Serializable {
    private static final long serialVersionUID = 6910543740464269629L;
    private static final Logger log = Logger.getLogger(DivertConfiguration.class);
    private String name;
    private String routingName;
    private String address;
    private String forwardingAddress;
    private boolean exclusive;
    private String filterString;
    private String transformerClassName;

    public DivertConfiguration(String name, String routingName, String address, String forwardingAddress, boolean exclusive, String filterString, String transformerClassName) {
        this.name = name;
        this.routingName = routingName == null ? UUIDGenerator.getInstance().generateStringUUID() : routingName;
        this.address = address;
        this.forwardingAddress = forwardingAddress;
        this.exclusive = exclusive;
        this.filterString = filterString;
        this.transformerClassName = transformerClassName;
    }

    public String getName() {
        return this.name;
    }

    public String getRoutingName() {
        return this.routingName;
    }

    public String getAddress() {
        return this.address;
    }

    public String getForwardingAddress() {
        return this.forwardingAddress;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public String getFilterString() {
        return this.filterString;
    }

    public String getTransformerClassName() {
        return this.transformerClassName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRoutingName(String routingName) {
        this.routingName = routingName;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setForwardingAddress(String forwardingAddress) {
        this.forwardingAddress = forwardingAddress;
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public void setFilterString(String filterString) {
        this.filterString = filterString;
    }

    public void setTransformerClassName(String transformerClassName) {
        this.transformerClassName = transformerClassName;
    }
}

