/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.journal.impl;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.impl.AbstractSequentialFile;
import org.hornetq.core.logging.Logger;

public class NIOSequentialFile
extends AbstractSequentialFile {
    private static final Logger log = Logger.getLogger(NIOSequentialFile.class);
    private FileChannel channel;
    private RandomAccessFile rfile;
    private Semaphore maxIOSemaphore;
    private final int defaultMaxIO;
    private int maxIO;

    public NIOSequentialFile(SequentialFileFactory factory, String directory, String fileName, int maxIO, Executor writerExecutor) {
        super(directory, new File(directory + "/" + fileName), factory, writerExecutor);
        this.defaultMaxIO = maxIO;
    }

    public NIOSequentialFile(SequentialFileFactory factory, File file, int maxIO, Executor writerExecutor) {
        super(file.getParent(), new File(file.getPath()), factory, writerExecutor);
        this.defaultMaxIO = maxIO;
    }

    @Override
    public int getAlignment() {
        return 1;
    }

    @Override
    public int calculateBlockStart(int position) throws Exception {
        return position;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.channel != null;
    }

    @Override
    public synchronized void open() throws Exception {
        this.open(this.defaultMaxIO, true);
    }

    @Override
    public void open(int maxIO, boolean useExecutor) throws Exception {
        this.rfile = new RandomAccessFile(this.getFile(), "rw");
        this.channel = this.rfile.getChannel();
        this.fileSize = this.channel.size();
        if (this.writerExecutor != null && useExecutor) {
            this.maxIOSemaphore = new Semaphore(maxIO);
            this.maxIO = maxIO;
        }
    }

    @Override
    public void fill(int position, int size, byte fillCharacter) throws Exception {
        ByteBuffer bb = ByteBuffer.allocate(size);
        for (int i = 0; i < size; ++i) {
            bb.put(fillCharacter);
        }
        bb.flip();
        this.channel.position(position);
        this.channel.write(bb);
        this.channel.force(false);
        this.channel.position(0L);
        this.fileSize = this.channel.size();
    }

    @Override
    public synchronized void waitForClose() throws Exception {
        while (this.isOpen()) {
            this.wait();
        }
    }

    @Override
    public synchronized void close() throws Exception {
        super.close();
        if (this.maxIOSemaphore != null) {
            while (!this.maxIOSemaphore.tryAcquire(this.maxIO, 60L, TimeUnit.SECONDS)) {
                log.warn("Couldn't get lock after 60 seconds on closing AsynchronousFileImpl::" + this.getFileName());
            }
        }
        this.maxIOSemaphore = null;
        if (this.channel != null) {
            this.channel.close();
        }
        if (this.rfile != null) {
            this.rfile.close();
        }
        this.channel = null;
        this.rfile = null;
        this.notifyAll();
    }

    @Override
    public int read(ByteBuffer bytes) throws Exception {
        return this.read(bytes, null);
    }

    @Override
    public int read(ByteBuffer bytes, IOAsyncTask callback) throws Exception {
        try {
            int bytesRead = this.channel.read(bytes);
            if (callback != null) {
                callback.done();
            }
            bytes.flip();
            return bytesRead;
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onError(6, e.getLocalizedMessage());
            }
            throw e;
        }
    }

    @Override
    public void sync() throws Exception {
        if (this.channel != null) {
            this.channel.force(false);
        }
    }

    @Override
    public long size() throws Exception {
        if (this.channel == null) {
            return this.getFile().length();
        }
        return this.channel.size();
    }

    @Override
    public void position(long pos) throws Exception {
        super.position(pos);
        this.channel.position(pos);
    }

    public String toString() {
        return "NIOSequentialFile " + this.getFile();
    }

    @Override
    public SequentialFile copy() {
        return new NIOSequentialFile(this.factory, this.getFile(), this.maxIO, this.writerExecutor);
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync, IOAsyncTask callback) {
        if (callback == null) {
            throw new NullPointerException("callback parameter need to be set");
        }
        try {
            this.internalWrite(bytes, sync, callback);
        }
        catch (Exception e) {
            callback.onError(-1, e.getMessage());
        }
    }

    @Override
    public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
        this.internalWrite(bytes, sync, null);
    }

    @Override
    protected ByteBuffer newBuffer(int size, int limit) {
        size = limit;
        return super.newBuffer(size, limit);
    }

    private void internalWrite(final ByteBuffer bytes, final boolean sync, final IOAsyncTask callback) throws Exception {
        if (!this.isOpen()) {
            if (callback == null) {
                throw new HornetQException(6, "File not opened");
            }
            callback.onError(6, "File not opened");
            return;
        }
        if (this.maxIOSemaphore == null) {
            this.doInternalWrite(bytes, sync, callback);
        } else {
            this.maxIOSemaphore.acquire();
            this.writerExecutor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        try {
                            NIOSequentialFile.this.doInternalWrite(bytes, sync, callback);
                        }
                        catch (Throwable e) {
                            log.warn("Exception on submitting write", e);
                            callback.onError(6, e.getMessage());
                        }
                    }
                    finally {
                        NIOSequentialFile.this.maxIOSemaphore.release();
                    }
                }
            });
        }
    }

    private void doInternalWrite(ByteBuffer bytes, boolean sync, IOAsyncTask callback) throws Exception {
        this.position.addAndGet(bytes.limit());
        this.channel.write(bytes);
        if (sync) {
            this.sync();
        }
        if (callback != null) {
            callback.done();
        }
    }
}

