/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.protocol.stomp.StompConnection;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.protocol.stomp.StompProtocolManager;
import org.hornetq.core.protocol.stomp.StompSubscription;
import org.hornetq.core.protocol.stomp.StompUtils;
import org.hornetq.core.server.QueueQueryResult;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.ServerSession;
import org.hornetq.spi.core.protocol.RemotingConnection;
import org.hornetq.spi.core.protocol.SessionCallback;
import org.hornetq.utils.UUIDGenerator;

class StompSession
implements SessionCallback {
    private static final Logger log = Logger.getLogger(StompSession.class);
    private final StompProtocolManager manager;
    private final StompConnection connection;
    private ServerSession session;
    private final OperationContext sessionContext;
    private final Map<Long, StompSubscription> subscriptions = new ConcurrentHashMap<Long, StompSubscription>();
    private final Map<Long, Long> messagesToAck = new ConcurrentHashMap<Long, Long>();
    private volatile boolean noLocal = false;

    StompSession(StompConnection connection, StompProtocolManager manager, OperationContext sessionContext) {
        this.connection = connection;
        this.manager = manager;
        this.sessionContext = sessionContext;
    }

    void setServerSession(ServerSession session) {
        this.session = session;
    }

    public ServerSession getSession() {
        return this.session;
    }

    @Override
    public void sendProducerCreditsMessage(int credits, SimpleString address) {
    }

    @Override
    public int sendMessage(ServerMessage serverMessage, long consumerID, int deliveryCount) {
        try {
            StompSubscription subscription = this.subscriptions.get(consumerID);
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("destination", serverMessage.getAddress().toString());
            if (subscription.getID() != null) {
                headers.put("subscription", subscription.getID());
            }
            HornetQBuffer buffer = serverMessage.getBodyBuffer();
            buffer.readerIndex(17);
            int bodyPos = serverMessage.getEndOfBodyPosition() == -1 ? buffer.writerIndex() : serverMessage.getEndOfBodyPosition();
            int size = bodyPos - buffer.readerIndex();
            byte[] data = new byte[size];
            if (serverMessage.containsProperty("content-length") || serverMessage.getType() == 4) {
                headers.put("content-length", data.length);
                buffer.readBytes(data);
            } else {
                SimpleString text = buffer.readNullableSimpleString();
                data = text != null ? text.toString().getBytes("UTF-8") : new byte[]{};
            }
            serverMessage.getBodyBuffer().resetReaderIndex();
            StompFrame frame = new StompFrame("MESSAGE", headers, data);
            StompUtils.copyStandardHeadersFromMessageToFrame(serverMessage, frame, deliveryCount);
            if (subscription.getAck().equals("auto")) {
                this.session.acknowledge(consumerID, serverMessage.getMessageID());
                this.session.commit();
            } else {
                this.messagesToAck.put(serverMessage.getMessageID(), consumerID);
            }
            this.manager.send(this.connection, frame);
            int length = frame.getEncodedSize();
            return length;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @Override
    public int sendLargeMessageContinuation(long consumerID, byte[] body, boolean continues, boolean requiresResponse) {
        return 0;
    }

    @Override
    public int sendLargeMessage(long consumerID, byte[] headerBuffer, long bodySize, int deliveryCount) {
        return 0;
    }

    @Override
    public void closed() {
    }

    public void acknowledge(String messageID) throws Exception {
        long id = Long.parseLong(messageID);
        long consumerID = this.messagesToAck.remove(id);
        this.session.acknowledge(consumerID, id);
        this.session.commit();
    }

    public void addSubscription(long consumerID, String subscriptionID, String clientID, String durableSubscriptionName, String destination, String selector, String ack) throws Exception {
        SimpleString queue = SimpleString.toSimpleString(destination);
        if (destination.startsWith("jms.topic")) {
            if (durableSubscriptionName != null) {
                if (clientID == null) {
                    throw new IllegalStateException("Cannot create a subscriber on the durable subscription if the client-id of the connection is not set");
                }
                queue = SimpleString.toSimpleString(clientID + "." + durableSubscriptionName);
                QueueQueryResult query = this.session.executeQueueQuery(queue);
                if (!query.isExists()) {
                    this.session.createQueue(SimpleString.toSimpleString(destination), queue, null, false, true);
                } else if (query.getConsumerCount() > 0) {
                    throw new IllegalStateException("Cannot create a subscriber on the durable subscription since it already has a subscriber: " + queue);
                }
            } else {
                queue = UUIDGenerator.getInstance().generateSimpleStringUUID();
                this.session.createQueue(SimpleString.toSimpleString(destination), queue, null, true, false);
            }
        }
        this.session.createConsumer(consumerID, queue, SimpleString.toSimpleString(selector), false);
        this.session.receiveConsumerCredits(consumerID, -1);
        StompSubscription subscription = new StompSubscription(subscriptionID, ack);
        this.subscriptions.put(consumerID, subscription);
        this.session.start();
    }

    public boolean unsubscribe(String id) throws Exception {
        Iterator<Map.Entry<Long, StompSubscription>> iterator = this.subscriptions.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Long, StompSubscription> entry = iterator.next();
            long consumerID = entry.getKey();
            StompSubscription sub = entry.getValue();
            if (id == null || !id.equals(sub.getID())) continue;
            iterator.remove();
            this.session.closeConsumer(consumerID);
            return true;
        }
        return false;
    }

    boolean containsSubscription(String subscriptionID) {
        for (Map.Entry<Long, StompSubscription> entry : this.subscriptions.entrySet()) {
            StompSubscription sub = entry.getValue();
            if (!sub.getID().equals(subscriptionID)) continue;
            return true;
        }
        return false;
    }

    public RemotingConnection getConnection() {
        return this.connection;
    }

    public OperationContext getContext() {
        return this.sessionContext;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }
}

