/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.nio.charset.Charset;
import org.hornetq.core.protocol.stomp.WebSocketStompFrameEncoder;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocket.WebSocketFrameDecoder;
import org.jboss.netty.util.CharsetUtil;

public class WebSocketServerHandler
extends SimpleChannelUpstreamHandler {
    private static final String WEBSOCKET_PATH = "/stomp";

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        Object msg = e.getMessage();
        if (msg instanceof HttpRequest) {
            this.handleHttpRequest(ctx, (HttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, HttpRequest req) {
        if (req.getMethod() != HttpMethod.GET) {
            this.sendHttpResponse(ctx, req, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        if (req.getUri().equals(WEBSOCKET_PATH) && "Upgrade".equalsIgnoreCase(req.getHeader("Connection")) && "WebSocket".equalsIgnoreCase(req.getHeader("Upgrade"))) {
            DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, new HttpResponseStatus(101, "Web Socket Protocol Handshake"));
            res.addHeader("Upgrade", (Object)"WebSocket");
            res.addHeader("Connection", (Object)"Upgrade");
            res.addHeader("WebSocket-Origin", (Object)req.getHeader("Origin"));
            res.addHeader("WebSocket-Location", (Object)this.getWebSocketLocation(req));
            String protocol = req.getHeader("WebSocket-Protocol");
            if (protocol != null) {
                res.addHeader("WebSocket-Protocol", (Object)protocol);
            }
            ChannelPipeline p = ctx.getChannel().getPipeline();
            p.remove("http-aggregator");
            p.replace("http-decoder", "ws-decoder", (ChannelHandler)new WebSocketFrameDecoder());
            ctx.getChannel().write((Object)res);
            p.replace("http-encoder", "ws-encoder", (ChannelHandler)new WebSocketStompFrameEncoder());
            return;
        }
        this.sendHttpResponse(ctx, req, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)frame.getBinaryData());
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        if (res.getStatus().getCode() != 200) {
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8));
            res.setHeader("Content-Length", (Object)Integer.toString(res.getContent().readableBytes()));
        }
        ChannelFuture f = ctx.getChannel().write((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().getCode() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        e.getCause().printStackTrace();
        e.getChannel().close();
    }

    private String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.getHeader("Host") + WEBSOCKET_PATH;
    }
}

