/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.server.cluster.impl;

import java.util.concurrent.Executor;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.server.Consumer;
import org.hornetq.core.server.HandleStatus;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.impl.TransactionImpl;
import org.hornetq.utils.Future;

public class Redistributor
implements Consumer {
    private static final Logger log = Logger.getLogger(Redistributor.class);
    private boolean active;
    private final StorageManager storageManager;
    private final PostOffice postOffice;
    private final Executor executor;
    private final int batchSize;
    private final Queue queue;
    private int count;

    public Redistributor(Queue queue, StorageManager storageManager, PostOffice postOffice, Executor executor, int batchSize) {
        this.queue = queue;
        this.storageManager = storageManager;
        this.postOffice = postOffice;
        this.executor = executor;
        this.batchSize = batchSize;
    }

    @Override
    public Filter getFilter() {
        return null;
    }

    public synchronized void start() {
        this.active = true;
    }

    public synchronized void stop() throws Exception {
        this.active = false;
        Future future = new Future();
        this.executor.execute(future);
        boolean ok = future.await(10000L);
        if (!ok) {
            log.warn("Timed out waiting for tasks to complete");
        }
    }

    public synchronized void close() {
        Future future = new Future();
        this.executor.execute(future);
        boolean ok = future.await(10000L);
        if (!ok) {
            throw new IllegalStateException("Timed out waiting for executor to complete");
        }
        this.active = false;
    }

    @Override
    public synchronized HandleStatus handle(MessageReference reference) throws Exception {
        if (!this.active) {
            return HandleStatus.BUSY;
        }
        TransactionImpl tx = new TransactionImpl(this.storageManager);
        boolean routed = this.postOffice.redistribute(reference.getMessage(), this.queue, tx);
        if (routed) {
            this.doRedistribute(reference, tx);
            return HandleStatus.HANDLED;
        }
        return HandleStatus.BUSY;
    }

    private void doRedistribute(MessageReference reference, Transaction tx) throws Exception {
        reference.handled();
        this.queue.acknowledge(tx, reference);
        tx.commit();
        this.storageManager.afterCompleteOperations(new IOAsyncTask(){

            @Override
            public void onError(int errorCode, String errorMessage) {
                log.warn("IO Error during redistribution, errorCode = " + errorCode + " message = " + errorMessage);
            }

            @Override
            public void done() {
                Redistributor.this.execPrompter();
            }
        });
    }

    private void execPrompter() {
        ++this.count;
        if (this.count == this.batchSize) {
            this.active = false;
            this.executor.execute(new Prompter());
            this.count = 0;
        }
    }

    private class Prompter
    implements Runnable {
        private Prompter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Redistributor redistributor = Redistributor.this;
            synchronized (redistributor) {
                Redistributor.this.active = true;
                Redistributor.this.queue.deliverAsync();
            }
        }
    }
}

