/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.transaction.impl;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQException;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperation;

public class TransactionImpl
implements Transaction {
    private List<TransactionOperation> operations;
    private static final Logger log = Logger.getLogger(TransactionImpl.class);
    private static final int INITIAL_NUM_PROPERTIES = 10;
    private Object[] properties = new Object[10];
    private final StorageManager storageManager;
    private final Xid xid;
    private final long id;
    private volatile Transaction.State state = Transaction.State.ACTIVE;
    private HornetQException exception;
    private final Object timeoutLock = new Object();
    private final long createTime;
    private volatile boolean containsPersistent;
    private int timeoutSeconds = -1;

    public TransactionImpl(StorageManager storageManager, int timeoutSeconds) {
        this.storageManager = storageManager;
        this.xid = null;
        this.id = storageManager.generateUniqueID();
        this.createTime = System.currentTimeMillis();
        this.timeoutSeconds = timeoutSeconds;
    }

    public TransactionImpl(StorageManager storageManager) {
        this.storageManager = storageManager;
        this.xid = null;
        this.id = storageManager.generateUniqueID();
        this.createTime = System.currentTimeMillis();
    }

    public TransactionImpl(Xid xid, StorageManager storageManager, int timeoutSeconds) {
        this.storageManager = storageManager;
        this.xid = xid;
        this.id = storageManager.generateUniqueID();
        this.createTime = System.currentTimeMillis();
        this.timeoutSeconds = timeoutSeconds;
    }

    public TransactionImpl(long id, Xid xid, StorageManager storageManager) {
        this.storageManager = storageManager;
        this.xid = xid;
        this.id = id;
        this.createTime = System.currentTimeMillis();
    }

    @Override
    public void setContainsPersistent() {
        this.containsPersistent = true;
    }

    @Override
    public void setTimeout(int timeout) {
        this.timeoutSeconds = timeout;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public boolean hasTimedOut(long currentTime, int defaultTimeout) {
        if (this.timeoutSeconds == -1) {
            return this.getState() != Transaction.State.PREPARED && currentTime > this.createTime + (long)(defaultTimeout * 1000);
        }
        return this.getState() != Transaction.State.PREPARED && currentTime > this.createTime + (long)(this.timeoutSeconds * 1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare() throws Exception {
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.state == Transaction.State.ROLLBACK_ONLY) {
                if (this.exception != null) {
                    throw this.exception;
                }
                return;
            }
            if (this.state != Transaction.State.ACTIVE) {
                throw new IllegalStateException("Transaction is in invalid state " + (Object)((Object)this.state));
            }
            if (this.xid == null) {
                throw new IllegalStateException("Cannot prepare non XA transaction");
            }
            if (this.operations != null) {
                for (TransactionOperation operation : this.operations) {
                    operation.beforePrepare(this);
                }
            }
            this.storageManager.prepare(this.id, this.xid);
            this.state = Transaction.State.PREPARED;
            this.storageManager.afterCompleteOperations(new IOAsyncTask(){

                @Override
                public void onError(int errorCode, String errorMessage) {
                    log.warn("IO Error completing the transaction, code = " + errorCode + ", message = " + errorMessage);
                }

                @Override
                public void done() {
                    if (TransactionImpl.this.operations != null) {
                        for (TransactionOperation operation : TransactionImpl.this.operations) {
                            try {
                                operation.afterPrepare(TransactionImpl.this);
                            }
                            catch (Exception e) {
                                log.warn(e.getMessage(), e);
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void commit() throws Exception {
        this.commit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(boolean onePhase) throws Exception {
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.state == Transaction.State.ROLLBACK_ONLY) {
                if (this.exception != null) {
                    throw this.exception;
                }
                return;
            }
            if (this.xid != null ? onePhase && this.state != Transaction.State.ACTIVE || !onePhase && this.state != Transaction.State.PREPARED : this.state != Transaction.State.ACTIVE) {
                throw new IllegalStateException("Transaction is in invalid state " + (Object)((Object)this.state));
            }
            if (this.operations != null) {
                for (TransactionOperation operation : this.operations) {
                    operation.beforeCommit(this);
                }
            }
            if (this.containsPersistent || this.xid != null && this.state == Transaction.State.PREPARED) {
                this.storageManager.commit(this.id);
                this.state = Transaction.State.COMMITTED;
            }
            this.storageManager.afterCompleteOperations(new IOAsyncTask(){

                @Override
                public void onError(int errorCode, String errorMessage) {
                    log.warn("IO Error completing the transaction, code = " + errorCode + ", message = " + errorMessage);
                }

                @Override
                public void done() {
                    if (TransactionImpl.this.operations != null) {
                        for (TransactionOperation operation : TransactionImpl.this.operations) {
                            try {
                                operation.afterCommit(TransactionImpl.this);
                            }
                            catch (Exception e) {
                                log.warn(e.getMessage(), e);
                            }
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws Exception {
        Object object = this.timeoutLock;
        synchronized (object) {
            if (this.xid != null ? this.state != Transaction.State.PREPARED && this.state != Transaction.State.ACTIVE : this.state != Transaction.State.ACTIVE && this.state != Transaction.State.ROLLBACK_ONLY) {
                throw new IllegalStateException("Transaction is in invalid state " + (Object)((Object)this.state));
            }
            if (this.operations != null) {
                for (TransactionOperation operation : this.operations) {
                    operation.beforeRollback(this);
                }
            }
            this.doRollback();
            this.state = Transaction.State.ROLLEDBACK;
            this.storageManager.afterCompleteOperations(new IOAsyncTask(){

                @Override
                public void onError(int errorCode, String errorMessage) {
                    log.warn("IO Error completing the transaction, code = " + errorCode + ", message = " + errorMessage);
                }

                @Override
                public void done() {
                    if (TransactionImpl.this.operations != null) {
                        for (TransactionOperation operation : TransactionImpl.this.operations) {
                            try {
                                operation.afterRollback(TransactionImpl.this);
                            }
                            catch (Exception e) {
                                log.warn(e.getMessage(), e);
                            }
                        }
                    }
                }
            });
        }
    }

    @Override
    public void suspend() {
        if (this.state != Transaction.State.ACTIVE) {
            throw new IllegalStateException("Can only suspend active transaction");
        }
        this.state = Transaction.State.SUSPENDED;
    }

    @Override
    public void resume() {
        if (this.state != Transaction.State.SUSPENDED) {
            throw new IllegalStateException("Can only resume a suspended transaction");
        }
        this.state = Transaction.State.ACTIVE;
    }

    @Override
    public Transaction.State getState() {
        return this.state;
    }

    @Override
    public void setState(Transaction.State state) {
        this.state = state;
    }

    @Override
    public Xid getXid() {
        return this.xid;
    }

    @Override
    public void markAsRollbackOnly(HornetQException exception) {
        this.state = Transaction.State.ROLLBACK_ONLY;
        this.exception = exception;
    }

    @Override
    public synchronized void addOperation(TransactionOperation operation) {
        this.checkCreateOperations();
        this.operations.add(operation);
    }

    @Override
    public void removeOperation(TransactionOperation operation) {
        this.checkCreateOperations();
        this.operations.remove(operation);
    }

    @Override
    public int getOperationsCount() {
        return this.operations.size();
    }

    @Override
    public void putProperty(int index, Object property) {
        if (index >= this.properties.length) {
            Object[] newProperties = new Object[index];
            System.arraycopy(this.properties, 0, newProperties, 0, this.properties.length);
            this.properties = newProperties;
        }
        this.properties[index] = property;
    }

    @Override
    public Object getProperty(int index) {
        return this.properties[index];
    }

    private void doRollback() throws Exception {
        if (this.containsPersistent || this.xid != null && this.state == Transaction.State.PREPARED) {
            this.storageManager.rollback(this.id);
        }
    }

    private void checkCreateOperations() {
        if (this.operations == null) {
            this.operations = new ArrayList<TransactionOperation>();
        }
    }
}

