/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.utils;

import java.util.Iterator;
import org.hornetq.core.logging.Logger;
import org.hornetq.utils.HQDeque;
import org.hornetq.utils.concurrent.BlockingDeque;
import org.hornetq.utils.concurrent.HQIterator;
import org.hornetq.utils.concurrent.HornetQConcurrentLinkedQueue;
import org.hornetq.utils.concurrent.LinkedBlockingDeque;

public class ConcurrentHQDeque<T>
implements HQDeque<T> {
    private static final Logger log = Logger.getLogger(ConcurrentHQDeque.class);
    private final HornetQConcurrentLinkedQueue<T> bodyQueue = new HornetQConcurrentLinkedQueue();
    private final BlockingDeque<T> headQueue = new LinkedBlockingDeque<T>();

    @Override
    public synchronized void addFirst(T t) {
        this.headQueue.addFirst(t);
    }

    @Override
    public void addLast(T t) {
        this.bodyQueue.add(t);
    }

    @Override
    public void clear() {
        this.bodyQueue.clear();
        this.headQueue.clear();
    }

    @Override
    public synchronized T getFirst() {
        if (this.headQueue.isEmpty()) {
            return this.bodyQueue.peek();
        }
        return (T)this.headQueue.peek();
    }

    @Override
    public boolean isEmpty() {
        return this.bodyQueue.isEmpty() && this.headQueue.isEmpty();
    }

    @Override
    public HQIterator<T> iterator() {
        return new Iter();
    }

    @Override
    public T removeFirst() {
        if (this.headQueue.isEmpty()) {
            return (T)this.bodyQueue.remove();
        }
        return (T)this.headQueue.remove();
    }

    private class Iter
    implements HQIterator<T> {
        private Iterator<T> headIter;
        private HQIterator<T> bodyIter;
        private boolean inHead;

        private Iter() {
            this.headIter = ConcurrentHQDeque.this.headQueue.iterator();
            this.bodyIter = ConcurrentHQDeque.this.bodyQueue.hqIterator();
        }

        @Override
        public T next() {
            if (this.headIter.hasNext()) {
                this.inHead = true;
                return this.headIter.next();
            }
            this.inHead = false;
            return this.bodyIter.next();
        }

        @Override
        public void remove() {
            if (this.inHead) {
                this.headIter.remove();
            } else {
                this.bodyIter.remove();
            }
        }
    }
}

