/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.client.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.api.core.client.ClusterTopologyListener;
import org.hornetq.core.client.impl.TopologyMember;

public class Topology
implements Serializable {
    private static final long serialVersionUID = -9037171688692471371L;
    private Map<String, TopologyMember> topology = new HashMap<String, TopologyMember>();
    private boolean debug;

    public synchronized boolean addMember(String nodeId, TopologyMember member) {
        boolean replaced = false;
        TopologyMember currentMember = this.topology.get(nodeId);
        if (this.debug && member.getConnector().toString().contains("server-id=4")) {
            System.out.println("member.getConnector() = " + member.getConnector());
        }
        if (currentMember == null) {
            this.topology.put(nodeId, member);
            replaced = true;
        } else {
            if (this.hasChanged((TransportConfiguration)currentMember.getConnector().a, (TransportConfiguration)member.getConnector().a) && member.getConnector().a != null) {
                currentMember.getConnector().a = member.getConnector().a;
                replaced = true;
            }
            if (this.hasChanged((TransportConfiguration)currentMember.getConnector().b, (TransportConfiguration)member.getConnector().b) && member.getConnector().b != null) {
                currentMember.getConnector().b = member.getConnector().b;
                replaced = true;
            }
            if (member.getConnector().a == null) {
                member.getConnector().a = currentMember.getConnector().a;
            }
            if (member.getConnector().b == null) {
                member.getConnector().b = currentMember.getConnector().b;
            }
        }
        return replaced;
    }

    public synchronized boolean removeMember(String nodeId) {
        TopologyMember member = this.topology.remove(nodeId);
        return member != null;
    }

    public synchronized void fireListeners(ClusterTopologyListener listener) {
        int count = 0;
        for (Map.Entry<String, TopologyMember> entry : this.topology.entrySet()) {
            listener.nodeUP(entry.getKey(), entry.getValue().getConnector(), ++count == this.topology.size());
        }
    }

    public TopologyMember getMember(String nodeID) {
        return this.topology.get(nodeID);
    }

    public boolean isEmpty() {
        return this.topology.isEmpty();
    }

    public Collection<TopologyMember> getMembers() {
        return this.topology.values();
    }

    public int nodes() {
        int count = 0;
        for (TopologyMember member : this.topology.values()) {
            if (member.getConnector().a != null) {
                ++count;
            }
            if (member.getConnector().b == null) continue;
            ++count;
        }
        return count;
    }

    public String describe() {
        String desc = "";
        for (Map.Entry<String, TopologyMember> entry : new HashMap<String, TopologyMember>(this.topology).entrySet()) {
            desc = desc + "\t" + entry.getKey() + " => " + entry.getValue() + "\n";
        }
        desc = desc + "\tnodes=" + this.nodes() + "\t" + "members=" + this.members();
        return desc;
    }

    public void clear() {
        this.topology.clear();
    }

    public int members() {
        return this.topology.size();
    }

    private boolean hasChanged(TransportConfiguration currentConnector, TransportConfiguration connector) {
        return currentConnector == null && connector != null || currentConnector != null && !currentConnector.equals(connector);
    }

    public TransportConfiguration getBackupForConnector(TransportConfiguration connectorConfiguration) {
        for (TopologyMember member : this.topology.values()) {
            if (member.getConnector().a == null || !((TransportConfiguration)member.getConnector().a).equals(connectorConfiguration)) continue;
            return (TransportConfiguration)member.getConnector().b;
        }
        return null;
    }

    public void setDebug(boolean b) {
        this.debug = b;
    }
}

