/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.cursor;

import java.lang.ref.WeakReference;
import org.hornetq.api.core.Message;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.cursor.PagedReference;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.transaction.Transaction;

public class PagedReferenceImpl
implements PagedReference {
    private static final long serialVersionUID = -8640232251318264710L;
    private final PagePosition position;
    private WeakReference<PagedMessage> message;
    private Long deliveryTime = null;
    private final PageSubscription subscription;

    @Override
    public ServerMessage getMessage() {
        return this.getPagedMessage().getMessage();
    }

    @Override
    public synchronized PagedMessage getPagedMessage() {
        PagedMessage returnMessage = (PagedMessage)this.message.get();
        if (returnMessage == null) {
            returnMessage = this.subscription.queryMessage(this.position);
            this.message = new WeakReference<PagedMessage>(returnMessage);
        }
        return returnMessage;
    }

    @Override
    public PagePosition getPosition() {
        return this.position;
    }

    public PagedReferenceImpl(PagePosition position, PagedMessage message, PageSubscription subscription) {
        this.position = position;
        this.message = new WeakReference<PagedMessage>(message);
        this.subscription = subscription;
    }

    @Override
    public boolean isPaged() {
        return true;
    }

    @Override
    public MessageReference copy(Queue queue) {
        return null;
    }

    @Override
    public long getScheduledDeliveryTime() {
        if (this.deliveryTime == null) {
            ServerMessage msg = this.getMessage();
            this.deliveryTime = msg.containsProperty(Message.HDR_SCHEDULED_DELIVERY_TIME) ? this.getMessage().getLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME) : Long.valueOf(0L);
        }
        return this.deliveryTime;
    }

    @Override
    public void setScheduledDeliveryTime(long scheduledDeliveryTime) {
        this.deliveryTime = scheduledDeliveryTime;
    }

    @Override
    public int getDeliveryCount() {
        return 0;
    }

    @Override
    public void setDeliveryCount(int deliveryCount) {
    }

    @Override
    public void incrementDeliveryCount() {
    }

    @Override
    public void decrementDeliveryCount() {
    }

    @Override
    public Queue getQueue() {
        return this.subscription.getQueue();
    }

    @Override
    public void handled() {
        this.getQueue().referenceHandled();
    }

    @Override
    public void acknowledge() throws Exception {
        this.subscription.ack(this);
    }

    @Override
    public void acknowledge(Transaction tx) throws Exception {
        this.subscription.ackTx(tx, this);
    }
}

