/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.cursor.impl;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.hornetq.api.core.Pair;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.paging.cursor.PageSubscriptionCounter;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperation;

public class PageSubscriptionCounterImpl
implements PageSubscriptionCounter {
    static final Logger log = Logger.getLogger(PageSubscriptionCounterImpl.class);
    private static final int FLUSH_COUNTER = 1000;
    private final long subscriptionID;
    private long recordID = -1L;
    private boolean persistent;
    private final StorageManager storage;
    private final AtomicLong value = new AtomicLong(0L);
    private final LinkedList<Long> incrementRecords = new LinkedList();
    private LinkedList<Pair<Long, Integer>> loadList;
    private final Executor executor;
    private final Runnable cleanupCheck = new Runnable(){

        @Override
        public void run() {
            PageSubscriptionCounterImpl.this.cleanup();
        }
    };

    public PageSubscriptionCounterImpl(StorageManager storage, boolean persistent, long subscriptionID, Executor executor) {
        this.subscriptionID = subscriptionID;
        this.storage = storage;
        this.executor = executor;
        this.persistent = persistent;
    }

    @Override
    public long getValue() {
        return this.value.get();
    }

    @Override
    public void increment(Transaction tx, int add) throws Exception {
        if (tx == null) {
            if (this.persistent) {
                long id = this.storage.storePageCounterInc(this.subscriptionID, add);
                this.incrementProcessed(id, add);
            } else {
                this.incrementProcessed(-1L, add);
            }
        } else if (this.persistent) {
            tx.setContainsPersistent();
            long id = this.storage.storePageCounterInc(tx.getID(), this.subscriptionID, add);
            this.applyIncrement(tx, id, add);
        } else {
            this.applyIncrement(tx, -1L, add);
        }
    }

    @Override
    public void applyIncrement(Transaction tx, long recordID, int add) {
        CounterOperations oper = (CounterOperations)tx.getProperty(3);
        if (oper == null) {
            oper = new CounterOperations();
            tx.putProperty(3, oper);
            tx.addOperation(oper);
        }
        oper.operations.add(new ItemOper(this, recordID, add));
    }

    @Override
    public synchronized void loadValue(long recordID, long value) {
        this.value.set(value);
        this.recordID = recordID;
    }

    public synchronized void incrementProcessed(long id, int add) {
        this.addInc(id, add);
        if (this.incrementRecords.size() > 1000) {
            this.executor.execute(this.cleanupCheck);
        }
    }

    @Override
    public void loadInc(long id, int add) {
        if (this.loadList == null) {
            this.loadList = new LinkedList();
        }
        this.loadList.add(new Pair<Long, Integer>(id, add));
    }

    @Override
    public void processReload() {
        if (this.loadList != null) {
            for (Pair pair : this.loadList) {
                this.value.addAndGet(((Integer)pair.b).intValue());
                this.incrementRecords.add((Long)pair.a);
            }
            this.loadList.clear();
            this.loadList = null;
        }
    }

    @Override
    public void addInc(long id, int variance) {
        this.value.addAndGet(variance);
        if (id >= 0L) {
            this.incrementRecords.add(id);
        }
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup() {
        ArrayList<Long> deleteList;
        long valueReplace;
        PageSubscriptionCounterImpl pageSubscriptionCounterImpl = this;
        synchronized (pageSubscriptionCounterImpl) {
            if (this.incrementRecords.size() <= 1000) {
                return;
            }
            valueReplace = this.value.get();
            deleteList = new ArrayList<Long>(this.incrementRecords.size());
            deleteList.addAll(this.incrementRecords);
            this.incrementRecords.clear();
        }
        long newRecordID = -1L;
        long txCleanup = this.storage.generateUniqueID();
        try {
            for (Long value : deleteList) {
                this.storage.deleteIncrementRecord(txCleanup, value);
            }
            if (this.recordID >= 0L) {
                this.storage.deletePageCounter(txCleanup, this.recordID);
            }
            newRecordID = this.storage.storePageCounter(txCleanup, this.subscriptionID, valueReplace);
            this.storage.commit(txCleanup);
            this.storage.waitOnOperations();
        }
        catch (Exception e) {
            newRecordID = this.recordID;
            log.warn(e.getMessage(), e);
            try {
                this.storage.rollback(txCleanup);
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        finally {
            this.recordID = newRecordID;
        }
    }

    static class CounterOperations
    implements TransactionOperation {
        LinkedList<ItemOper> operations = new LinkedList();

        CounterOperations() {
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
        }

        @Override
        public void afterPrepare(Transaction tx) {
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (ItemOper oper : this.operations) {
                oper.counter.incrementProcessed(oper.id, oper.ammount);
            }
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
        }

        @Override
        public void afterRollback(Transaction tx) {
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return null;
        }
    }

    static class ItemOper {
        PageSubscriptionCounterImpl counter;
        long id;
        int ammount;

        public ItemOper(PageSubscriptionCounterImpl counter, long id, int add) {
            this.counter = counter;
            this.id = id;
            this.ammount = add;
        }
    }
}

