/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.persistence.OperationContext;

public class PageSyncTimer {
    private final PagingStore store;
    private final ScheduledExecutorService scheduledExecutor;
    private boolean pendingSync;
    private final long timeSync;
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            PageSyncTimer.this.tick();
        }
    };
    private List<OperationContext> syncOperations = new LinkedList<OperationContext>();

    public PageSyncTimer(PagingStore store, ScheduledExecutorService scheduledExecutor, long timeSync) {
        this.store = store;
        this.scheduledExecutor = scheduledExecutor;
        this.timeSync = timeSync;
    }

    public synchronized void addSync(OperationContext ctx) {
        ctx.pageSyncLineUp();
        if (!this.pendingSync) {
            this.pendingSync = true;
            this.scheduledExecutor.schedule(this.runnable, this.timeSync, TimeUnit.NANOSECONDS);
        }
        this.syncOperations.add(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        OperationContext[] pendingSyncsArray;
        PageSyncTimer pageSyncTimer = this;
        synchronized (pageSyncTimer) {
            this.pendingSync = false;
            pendingSyncsArray = new OperationContext[this.syncOperations.size()];
            pendingSyncsArray = this.syncOperations.toArray(pendingSyncsArray);
            this.syncOperations.clear();
        }
        try {
            this.store.ioSync();
        }
        catch (Exception e) {
            for (OperationContext ctx : pendingSyncsArray) {
                ctx.onError(6, e.getMessage());
            }
        }
        finally {
            for (OperationContext ctx : pendingSyncsArray) {
                ctx.pageSyncDone();
            }
        }
    }
}

