/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.paging.impl;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.paging.PageTransactionInfo;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.PagingStoreFactory;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.settings.HierarchicalRepository;
import org.hornetq.core.settings.impl.AddressSettings;

public class PagingManagerImpl
implements PagingManager {
    private volatile boolean started = false;
    private final ConcurrentMap<SimpleString, PagingStore> stores = new ConcurrentHashMap<SimpleString, PagingStore>();
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final PagingStoreFactory pagingStoreFactory;
    private final StorageManager storageManager;
    private final ConcurrentMap<Long, PageTransactionInfo> transactions = new ConcurrentHashMap<Long, PageTransactionInfo>();
    private static final Logger log = Logger.getLogger(PagingManagerImpl.class);

    public PagingManagerImpl(PagingStoreFactory pagingSPI, StorageManager storageManager, HierarchicalRepository<AddressSettings> addressSettingsRepository) {
        this.pagingStoreFactory = pagingSPI;
        this.addressSettingsRepository = addressSettingsRepository;
        this.storageManager = storageManager;
    }

    @Override
    public SimpleString[] getStoreNames() {
        Set names = this.stores.keySet();
        return names.toArray(new SimpleString[names.size()]);
    }

    @Override
    public synchronized void reloadStores() throws Exception {
        List<PagingStore> reloadedStores = this.pagingStoreFactory.reloadStores(this.addressSettingsRepository);
        for (PagingStore store : reloadedStores) {
            store.start();
            this.stores.put(store.getStoreName(), store);
        }
    }

    private synchronized PagingStore createPageStore(SimpleString storeName) throws Exception {
        PagingStore store = (PagingStore)this.stores.get(storeName);
        if (store == null) {
            store = this.newStore(storeName);
            store.start();
            this.stores.put(storeName, store);
        }
        return store;
    }

    @Override
    public void deletePageStore(SimpleString storeName) throws Exception {
        PagingStore store = (PagingStore)this.stores.remove(storeName);
        if (store != null) {
            store.stop();
        }
    }

    @Override
    public PagingStore getPageStore(SimpleString storeName) throws Exception {
        PagingStore store = (PagingStore)this.stores.get(storeName);
        if (store == null) {
            store = this.createPageStore(storeName);
        }
        return store;
    }

    @Override
    public void setPostOffice(PostOffice postOffice) {
        this.pagingStoreFactory.setPostOffice(postOffice);
    }

    @Override
    public void addTransaction(PageTransactionInfo pageTransaction) {
        this.transactions.put(pageTransaction.getTransactionID(), pageTransaction);
    }

    @Override
    public void removeTransaction(long id) {
        this.transactions.remove(id);
    }

    @Override
    public PageTransactionInfo getTransaction(long id) {
        return (PageTransactionInfo)this.transactions.get(id);
    }

    @Override
    public Map<Long, PageTransactionInfo> getTransactions() {
        return this.transactions;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.pagingStoreFactory.setPagingManager(this);
        this.pagingStoreFactory.setStorageManager(this.storageManager);
        this.reloadStores();
        this.started = true;
    }

    @Override
    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (PagingStore store : this.stores.values()) {
            store.stop();
        }
        this.pagingStoreFactory.stop();
    }

    @Override
    public void processReload() throws Exception {
        for (PagingStore store : this.stores.values()) {
            store.processReload();
        }
    }

    protected PagingStore newStore(SimpleString address) {
        return this.pagingStoreFactory.newStore(address, this.addressSettingsRepository.getMatch(address.toString()));
    }

    protected PagingStoreFactory getStoreFactory() {
        return this.pagingStoreFactory;
    }
}

