/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.persistence.impl.journal;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javax.transaction.xa.Xid;
import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.HornetQBuffers;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.Pair;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.config.Configuration;
import org.hornetq.core.filter.Filter;
import org.hornetq.core.journal.EncodingSupport;
import org.hornetq.core.journal.IOAsyncTask;
import org.hornetq.core.journal.IOCompletion;
import org.hornetq.core.journal.Journal;
import org.hornetq.core.journal.JournalLoadInformation;
import org.hornetq.core.journal.PreparedTransactionInfo;
import org.hornetq.core.journal.RecordInfo;
import org.hornetq.core.journal.SequentialFile;
import org.hornetq.core.journal.SequentialFileFactory;
import org.hornetq.core.journal.TransactionFailureCallback;
import org.hornetq.core.journal.impl.AIOSequentialFileFactory;
import org.hornetq.core.journal.impl.AbstractSequentialFileFactory;
import org.hornetq.core.journal.impl.JournalImpl;
import org.hornetq.core.journal.impl.NIOSequentialFileFactory;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.paging.PageTransactionInfo;
import org.hornetq.core.paging.PagedMessage;
import org.hornetq.core.paging.PagingManager;
import org.hornetq.core.paging.PagingStore;
import org.hornetq.core.paging.cursor.PagePosition;
import org.hornetq.core.paging.cursor.PageSubscription;
import org.hornetq.core.paging.cursor.impl.PagePositionImpl;
import org.hornetq.core.paging.impl.PageTransactionInfoImpl;
import org.hornetq.core.persistence.GroupingInfo;
import org.hornetq.core.persistence.OperationContext;
import org.hornetq.core.persistence.QueueBindingInfo;
import org.hornetq.core.persistence.StorageManager;
import org.hornetq.core.persistence.config.PersistedAddressSetting;
import org.hornetq.core.persistence.config.PersistedRoles;
import org.hornetq.core.persistence.impl.journal.BatchingIDGenerator;
import org.hornetq.core.persistence.impl.journal.LargeServerMessageImpl;
import org.hornetq.core.persistence.impl.journal.OperationContextImpl;
import org.hornetq.core.postoffice.Binding;
import org.hornetq.core.postoffice.PostOffice;
import org.hornetq.core.replication.ReplicationManager;
import org.hornetq.core.replication.impl.ReplicatedJournal;
import org.hornetq.core.server.JournalType;
import org.hornetq.core.server.LargeServerMessage;
import org.hornetq.core.server.MessageReference;
import org.hornetq.core.server.Queue;
import org.hornetq.core.server.ServerMessage;
import org.hornetq.core.server.group.impl.GroupBinding;
import org.hornetq.core.server.impl.ServerMessageImpl;
import org.hornetq.core.transaction.ResourceManager;
import org.hornetq.core.transaction.Transaction;
import org.hornetq.core.transaction.TransactionOperation;
import org.hornetq.core.transaction.impl.TransactionImpl;
import org.hornetq.utils.ExecutorFactory;
import org.hornetq.utils.UUID;
import org.hornetq.utils.XidCodecSupport;

public class JournalStorageManager
implements StorageManager {
    private static final Logger log = Logger.getLogger(JournalStorageManager.class);
    private static final long CHECKPOINT_BATCH_SIZE = Integer.MAX_VALUE;
    public static final byte GROUP_RECORD = 41;
    public static final byte QUEUE_BINDING_RECORD = 21;
    public static final byte ID_COUNTER_RECORD = 24;
    public static final byte ADDRESS_SETTING_RECORD = 25;
    public static final byte SECURITY_RECORD = 26;
    public static final int SIZE_FIELDS = 21;
    public static final byte ADD_LARGE_MESSAGE = 30;
    public static final byte ADD_MESSAGE = 31;
    public static final byte ADD_REF = 32;
    public static final byte ACKNOWLEDGE_REF = 33;
    public static final byte UPDATE_DELIVERY_COUNT = 34;
    public static final byte PAGE_TRANSACTION = 35;
    public static final byte SET_SCHEDULED_DELIVERY_TIME = 36;
    public static final byte DUPLICATE_ID = 37;
    public static final byte HEURISTIC_COMPLETION = 38;
    public static final byte ACKNOWLEDGE_CURSOR = 39;
    public static final byte PAGE_CURSOR_COUNTER_VALUE = 40;
    public static final byte PAGE_CURSOR_COUNTER_INC = 41;
    private UUID persistentID;
    private final BatchingIDGenerator idGenerator;
    private final ReplicationManager replicator;
    private final Journal messageJournal;
    private final Journal bindingsJournal;
    private final SequentialFileFactory largeMessagesFactory;
    private volatile boolean started;
    private final ExecutorFactory executorFactory;
    private final Executor executor;
    private final boolean syncTransactional;
    private final boolean syncNonTransactional;
    private final int perfBlastPages;
    private final boolean createBindingsDir;
    private final String bindingsDir;
    private final boolean createJournalDir;
    private final String journalDir;
    private final String largeMessagesDirectory;
    private boolean journalLoaded = false;
    private final Map<SimpleString, PersistedRoles> mapPersistedRoles = new ConcurrentHashMap<SimpleString, PersistedRoles>();
    private final Map<SimpleString, PersistedAddressSetting> mapPersistedAddressSettings = new ConcurrentHashMap<SimpleString, PersistedAddressSetting>();

    public JournalStorageManager(Configuration config, ExecutorFactory executorFactory) {
        this(config, executorFactory, null);
    }

    public JournalStorageManager(Configuration config, ExecutorFactory executorFactory, ReplicationManager replicator) {
        this.executorFactory = executorFactory;
        this.executor = executorFactory.getExecutor();
        this.replicator = replicator;
        if (config.getJournalType() != JournalType.NIO && config.getJournalType() != JournalType.ASYNCIO) {
            throw new IllegalArgumentException("Only NIO and AsyncIO are supported journals");
        }
        this.bindingsDir = config.getBindingsDirectory();
        if (this.bindingsDir == null) {
            throw new NullPointerException("bindings-dir is null");
        }
        this.createBindingsDir = config.isCreateBindingsDir();
        this.journalDir = config.getJournalDirectory();
        NIOSequentialFileFactory bindingsFF = new NIOSequentialFileFactory(this.bindingsDir);
        JournalImpl localBindings = new JournalImpl(0x100000, 2, config.getJournalCompactMinFiles(), config.getJournalCompactPercentage(), bindingsFF, "hornetq-bindings", "bindings", 1);
        this.bindingsJournal = replicator != null ? new ReplicatedJournal(0, localBindings, replicator) : localBindings;
        if (this.journalDir == null) {
            throw new NullPointerException("journal-dir is null");
        }
        this.createJournalDir = config.isCreateJournalDir();
        this.syncNonTransactional = config.isJournalSyncNonTransactional();
        this.syncTransactional = config.isJournalSyncTransactional();
        AbstractSequentialFileFactory journalFF = null;
        if (config.getJournalType() == JournalType.ASYNCIO) {
            log.info("Using AIO Journal");
            journalFF = new AIOSequentialFileFactory(this.journalDir, config.getJournalBufferSize_AIO(), config.getJournalBufferTimeout_AIO(), config.isLogJournalWriteRate());
        } else if (config.getJournalType() == JournalType.NIO) {
            log.info("Using NIO Journal");
            journalFF = new NIOSequentialFileFactory(this.journalDir, true, config.getJournalBufferSize_NIO(), config.getJournalBufferTimeout_NIO(), config.isLogJournalWriteRate());
        } else {
            throw new IllegalArgumentException("Unsupported journal type " + (Object)((Object)config.getJournalType()));
        }
        this.idGenerator = config.isBackup() && !config.isSharedStore() ? null : new BatchingIDGenerator(0L, Integer.MAX_VALUE, this.bindingsJournal);
        JournalImpl localMessage = new JournalImpl(config.getJournalFileSize(), config.getJournalMinFiles(), config.getJournalCompactMinFiles(), config.getJournalCompactPercentage(), journalFF, "hornetq-data", "hq", config.getJournalType() == JournalType.ASYNCIO ? config.getJournalMaxIO_AIO() : config.getJournalMaxIO_NIO());
        this.messageJournal = replicator != null ? new ReplicatedJournal(1, localMessage, replicator) : localMessage;
        this.largeMessagesDirectory = config.getLargeMessagesDirectory();
        this.largeMessagesFactory = new NIOSequentialFileFactory(this.largeMessagesDirectory, false);
        this.perfBlastPages = config.getJournalPerfBlastPages();
    }

    @Override
    public void clearContext() {
        OperationContextImpl.clearContext();
    }

    @Override
    public boolean isReplicated() {
        return this.replicator != null;
    }

    @Override
    public void waitOnOperations() throws Exception {
        if (!this.started) {
            log.warn("Server is stopped");
            throw new IllegalStateException("Server is stopped");
        }
        this.waitOnOperations(0L);
    }

    @Override
    public void waitOnOperations(long timeout) throws Exception {
        if (!this.started) {
            log.warn("Server is stopped");
            throw new IllegalStateException("Server is stopped");
        }
        if (!this.getContext().waitCompletion(timeout)) {
            throw new HornetQException(6, "Timeout on waiting I/O completion");
        }
    }

    @Override
    public void pageClosed(SimpleString storeName, int pageNumber) {
        if (this.isReplicated()) {
            this.replicator.pageClosed(storeName, pageNumber);
        }
    }

    @Override
    public void pageDeleted(SimpleString storeName, int pageNumber) {
        if (this.isReplicated()) {
            this.replicator.pageDeleted(storeName, pageNumber);
        }
    }

    @Override
    public void pageWrite(PagedMessage message, int pageNumber) {
        if (this.isReplicated()) {
            this.replicator.pageWrite(message, pageNumber);
        }
    }

    @Override
    public OperationContext getContext() {
        return OperationContextImpl.getContext(this.executorFactory);
    }

    @Override
    public void setContext(OperationContext context) {
        OperationContextImpl.setContext(context);
    }

    @Override
    public OperationContext newContext(Executor executor) {
        return new OperationContextImpl(executor);
    }

    @Override
    public void afterCompleteOperations(IOAsyncTask run) {
        this.getContext().executeOnCompletion(run);
    }

    @Override
    public long generateUniqueID() {
        long id = this.idGenerator.generateID();
        return id;
    }

    @Override
    public long getCurrentUniqueID() {
        return this.idGenerator.getCurrentID();
    }

    @Override
    public LargeServerMessage createLargeMessage() {
        return new LargeServerMessageImpl(this);
    }

    public void addBytesToLargeMessage(SequentialFile file, long messageId, byte[] bytes) throws Exception {
        file.position(file.size());
        file.writeDirect(ByteBuffer.wrap(bytes), false);
        if (this.isReplicated()) {
            this.replicator.largeMessageWrite(messageId, bytes);
        }
    }

    @Override
    public LargeServerMessage createLargeMessage(long id, MessageInternal message) {
        if (this.isReplicated()) {
            this.replicator.largeMessageBegin(id);
        }
        LargeServerMessageImpl largeMessage = (LargeServerMessageImpl)this.createLargeMessage();
        largeMessage.copyHeadersAndProperties(message);
        largeMessage.setMessageID(id);
        return largeMessage;
    }

    @Override
    public void storeMessage(ServerMessage message) throws Exception {
        if (message.getMessageID() <= 0L) {
            throw new HornetQException(104, "MessageId was not assigned to Message");
        }
        if (message.isLargeMessage()) {
            this.messageJournal.appendAddRecord(message.getMessageID(), (byte)30, new LargeMessageEncoding((LargeServerMessage)message), false, (IOCompletion)this.getContext(false));
        } else {
            this.messageJournal.appendAddRecord(message.getMessageID(), (byte)31, message, false, (IOCompletion)this.getContext(false));
        }
    }

    @Override
    public void storeReference(long queueID, long messageID, boolean last) throws Exception {
        this.messageJournal.appendUpdateRecord(messageID, (byte)32, new RefEncoding(queueID), last && this.syncNonTransactional, (IOCompletion)this.getContext(last && this.syncNonTransactional));
    }

    @Override
    public void storeAcknowledge(long queueID, long messageID) throws Exception {
        this.messageJournal.appendUpdateRecord(messageID, (byte)33, new RefEncoding(queueID), this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
    }

    @Override
    public void storeCursorAcknowledge(long queueID, PagePosition position) throws Exception {
        long ackID = this.idGenerator.generateID();
        position.setRecordID(ackID);
        this.messageJournal.appendAddRecord(ackID, (byte)39, new CursorAckRecordEncoding(queueID, position), this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
    }

    @Override
    public void deleteMessage(long messageID) throws Exception {
        this.messageJournal.appendDeleteRecord(messageID, false, this.getContext(false));
    }

    @Override
    public void updateScheduledDeliveryTime(MessageReference ref) throws Exception {
        ScheduledDeliveryEncoding encoding = new ScheduledDeliveryEncoding(ref.getScheduledDeliveryTime(), ref.getQueue().getID());
        this.messageJournal.appendUpdateRecord(ref.getMessage().getMessageID(), (byte)36, encoding, this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
    }

    @Override
    public void storeDuplicateID(SimpleString address, byte[] duplID, long recordID) throws Exception {
        DuplicateIDEncoding encoding = new DuplicateIDEncoding(address, duplID);
        this.messageJournal.appendAddRecord(recordID, (byte)37, encoding, this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
    }

    @Override
    public void deleteDuplicateID(long recordID) throws Exception {
        this.messageJournal.appendDeleteRecord(recordID, this.syncNonTransactional, this.getContext(this.syncNonTransactional));
    }

    @Override
    public void storeMessageTransactional(long txID, ServerMessage message) throws Exception {
        if (message.getMessageID() <= 0L) {
            throw new HornetQException(104, "MessageId was not assigned to Message");
        }
        if (message.isLargeMessage()) {
            this.messageJournal.appendAddRecordTransactional(txID, message.getMessageID(), (byte)30, new LargeMessageEncoding((LargeServerMessage)message));
        } else {
            this.messageJournal.appendAddRecordTransactional(txID, message.getMessageID(), (byte)31, message);
        }
    }

    @Override
    public void storePageTransaction(long txID, PageTransactionInfo pageTransaction) throws Exception {
        pageTransaction.setRecordID(this.generateUniqueID());
        this.messageJournal.appendAddRecordTransactional(txID, pageTransaction.getRecordID(), (byte)35, pageTransaction);
    }

    @Override
    public void updatePageTransaction(long txID, PageTransactionInfo pageTransaction, int depages) throws Exception {
        this.messageJournal.appendUpdateRecordTransactional(txID, pageTransaction.getRecordID(), (byte)35, new PageUpdateTXEncoding(pageTransaction.getTransactionID(), depages));
    }

    @Override
    public void updatePageTransaction(PageTransactionInfo pageTransaction, int depages) throws Exception {
        this.messageJournal.appendUpdateRecord(pageTransaction.getRecordID(), (byte)35, new PageUpdateTXEncoding(pageTransaction.getTransactionID(), depages), this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
    }

    @Override
    public void storeReferenceTransactional(long txID, long queueID, long messageID) throws Exception {
        this.messageJournal.appendUpdateRecordTransactional(txID, messageID, (byte)32, new RefEncoding(queueID));
    }

    @Override
    public void storeAcknowledgeTransactional(long txID, long queueID, long messageID) throws Exception {
        this.messageJournal.appendUpdateRecordTransactional(txID, messageID, (byte)33, new RefEncoding(queueID));
    }

    @Override
    public void storeCursorAcknowledgeTransactional(long txID, long queueID, PagePosition position) throws Exception {
        long ackID = this.idGenerator.generateID();
        position.setRecordID(ackID);
        this.messageJournal.appendAddRecordTransactional(txID, ackID, (byte)39, new CursorAckRecordEncoding(queueID, position));
    }

    @Override
    public void deleteCursorAcknowledgeTransactional(long txID, long ackID) throws Exception {
        this.messageJournal.appendDeleteRecordTransactional(txID, ackID);
    }

    @Override
    public long storeHeuristicCompletion(Xid xid, boolean isCommit) throws Exception {
        long id = this.generateUniqueID();
        this.messageJournal.appendAddRecord(id, (byte)38, new HeuristicCompletionEncoding(xid, isCommit), true, (IOCompletion)this.getContext(true));
        return id;
    }

    @Override
    public void deleteHeuristicCompletion(long id) throws Exception {
        this.messageJournal.appendDeleteRecord(id, true, this.getContext(true));
    }

    @Override
    public void deletePageTransactional(long recordID) throws Exception {
        this.messageJournal.appendDeleteRecord(recordID, false);
    }

    @Override
    public void updateScheduledDeliveryTimeTransactional(long txID, MessageReference ref) throws Exception {
        ScheduledDeliveryEncoding encoding = new ScheduledDeliveryEncoding(ref.getScheduledDeliveryTime(), ref.getQueue().getID());
        this.messageJournal.appendUpdateRecordTransactional(txID, ref.getMessage().getMessageID(), (byte)36, encoding);
    }

    @Override
    public void deleteMessageTransactional(long txID, long queueID, long messageID) throws Exception {
        this.messageJournal.appendDeleteRecordTransactional(txID, messageID, new DeleteEncoding(queueID));
    }

    @Override
    public void prepare(long txID, Xid xid) throws Exception {
        this.messageJournal.appendPrepareRecord(txID, new XidEncoding(xid), this.syncTransactional, (IOCompletion)this.getContext(this.syncTransactional));
    }

    @Override
    public void commit(long txID) throws Exception {
        this.messageJournal.appendCommitRecord(txID, this.syncTransactional, this.getContext(this.syncTransactional));
    }

    @Override
    public void rollback(long txID) throws Exception {
        this.messageJournal.appendRollbackRecord(txID, this.syncTransactional, this.getContext(this.syncTransactional));
    }

    @Override
    public void storeDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
        DuplicateIDEncoding encoding = new DuplicateIDEncoding(address, duplID);
        this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)37, encoding);
    }

    @Override
    public void updateDuplicateIDTransactional(long txID, SimpleString address, byte[] duplID, long recordID) throws Exception {
        DuplicateIDEncoding encoding = new DuplicateIDEncoding(address, duplID);
        this.messageJournal.appendUpdateRecordTransactional(txID, recordID, (byte)37, encoding);
    }

    @Override
    public void deleteDuplicateIDTransactional(long txID, long recordID) throws Exception {
        this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
    }

    @Override
    public void updateDeliveryCount(MessageReference ref) throws Exception {
        DeliveryCountUpdateEncoding updateInfo = new DeliveryCountUpdateEncoding(ref.getQueue().getID(), ref.getDeliveryCount());
        this.messageJournal.appendUpdateRecord(ref.getMessage().getMessageID(), (byte)34, updateInfo, this.syncNonTransactional, (IOCompletion)this.getContext(this.syncNonTransactional));
    }

    @Override
    public void storeAddressSetting(PersistedAddressSetting addressSetting) throws Exception {
        this.deleteAddressSetting(addressSetting.getAddressMatch());
        long id = this.idGenerator.generateID();
        addressSetting.setStoreId(id);
        this.bindingsJournal.appendAddRecord(id, (byte)25, addressSetting, true);
        this.mapPersistedAddressSettings.put(addressSetting.getAddressMatch(), addressSetting);
    }

    @Override
    public List<PersistedAddressSetting> recoverAddressSettings() throws Exception {
        ArrayList<PersistedAddressSetting> list = new ArrayList<PersistedAddressSetting>(this.mapPersistedAddressSettings.size());
        list.addAll(this.mapPersistedAddressSettings.values());
        return list;
    }

    @Override
    public List<PersistedRoles> recoverPersistedRoles() throws Exception {
        ArrayList<PersistedRoles> list = new ArrayList<PersistedRoles>(this.mapPersistedRoles.size());
        list.addAll(this.mapPersistedRoles.values());
        return list;
    }

    @Override
    public void storeSecurityRoles(PersistedRoles persistedRoles) throws Exception {
        this.deleteSecurityRoles(persistedRoles.getAddressMatch());
        long id = this.idGenerator.generateID();
        persistedRoles.setStoreId(id);
        this.bindingsJournal.appendAddRecord(id, (byte)26, persistedRoles, true);
        this.mapPersistedRoles.put(persistedRoles.getAddressMatch(), persistedRoles);
    }

    @Override
    public void deleteAddressSetting(SimpleString addressMatch) throws Exception {
        PersistedAddressSetting oldSetting = this.mapPersistedAddressSettings.remove(addressMatch);
        if (oldSetting != null) {
            this.bindingsJournal.appendDeleteRecord(oldSetting.getStoreId(), false);
        }
    }

    @Override
    public void deleteSecurityRoles(SimpleString addressMatch) throws Exception {
        PersistedRoles oldRoles = this.mapPersistedRoles.remove(addressMatch);
        if (oldRoles != null) {
            this.bindingsJournal.appendDeleteRecord(oldRoles.getStoreId(), false);
        }
    }

    @Override
    public JournalLoadInformation loadMessageJournal(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, Queue> queues, Map<Long, QueueBindingInfo> queueInfos, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap) throws Exception {
        ArrayList<RecordInfo> records = new ArrayList<RecordInfo>();
        ArrayList<PreparedTransactionInfo> preparedTransactions = new ArrayList<PreparedTransactionInfo>();
        HashMap<Long, ServerMessage> messages = new HashMap<Long, ServerMessage>();
        JournalLoadInformation info = this.messageJournal.load(records, preparedTransactions, new LargeMessageTXFailureCallback(messages));
        ArrayList<LargeServerMessage> largeMessages = new ArrayList<LargeServerMessage>();
        HashMap queueMap = new HashMap();
        HashMap<Long, PageSubscription> pageSubscriptions = new HashMap<Long, PageSubscription>();
        int totalSize = records.size();
        for (int reccount = 0; reccount < totalSize; ++reccount) {
            if (reccount > 0 && reccount % 1000000 == 0) {
                long l = (long)((double)reccount / (double)totalSize * 100.0);
                log.info(l + "% loaded");
            }
            RecordInfo recordInfo = (RecordInfo)records.get(reccount);
            byte[] data = recordInfo.data;
            HornetQBuffer buff = HornetQBuffers.wrappedBuffer(data);
            byte recordType = recordInfo.getUserRecordType();
            switch (recordType) {
                case 30: {
                    LargeServerMessage largeMessage = this.parseLargeMessage(messages, buff);
                    messages.put(recordInfo.id, largeMessage);
                    largeMessages.add(largeMessage);
                    break;
                }
                case 31: {
                    ServerMessageImpl message = new ServerMessageImpl(recordInfo.id, 50);
                    message.decode(buff);
                    messages.put(recordInfo.id, message);
                    break;
                }
                case 32: {
                    ServerMessage message;
                    long messageID = recordInfo.id;
                    EncodingSupport encoding = new RefEncoding();
                    ((QueueEncoding)encoding).decode(buff);
                    LinkedHashMap<Long, AddMessageRecord> queueMessages = (LinkedHashMap<Long, AddMessageRecord>)queueMap.get(((RefEncoding)encoding).queueID);
                    if (queueMessages == null) {
                        queueMessages = new LinkedHashMap<Long, AddMessageRecord>();
                        queueMap.put(((RefEncoding)encoding).queueID, queueMessages);
                    }
                    if ((message = (ServerMessage)messages.get(messageID)) == null) {
                        throw new IllegalStateException("Cannot find message " + recordInfo.id);
                    }
                    queueMessages.put(messageID, new AddMessageRecord(message));
                    break;
                }
                case 33: {
                    long messageID = recordInfo.id;
                    EncodingSupport encoding = new RefEncoding();
                    ((QueueEncoding)encoding).decode(buff);
                    LinkedHashMap<Long, AddMessageRecord> queueMessages = (Map)queueMap.get(((RefEncoding)encoding).queueID);
                    if (queueMessages == null) {
                        throw new IllegalStateException("Cannot find queue messages " + ((RefEncoding)encoding).queueID);
                    }
                    AddMessageRecord rec = (AddMessageRecord)queueMessages.remove(messageID);
                    if (rec != null) break;
                    throw new IllegalStateException("Cannot find message " + messageID);
                }
                case 34: {
                    long messageID = recordInfo.id;
                    EncodingSupport encoding = new DeliveryCountUpdateEncoding();
                    ((DeliveryCountUpdateEncoding)encoding).decode(buff);
                    LinkedHashMap<Long, AddMessageRecord> queueMessages = (Map)queueMap.get(((DeliveryCountUpdateEncoding)encoding).queueID);
                    if (queueMessages == null) {
                        log.warn("Cannot find queue " + ((DeliveryCountUpdateEncoding)encoding).queueID + " to update delivery count");
                        break;
                    }
                    AddMessageRecord rec = (AddMessageRecord)queueMessages.get(messageID);
                    if (rec == null) {
                        log.warn("Cannot find message " + messageID + " to update delivery count");
                        break;
                    }
                    rec.deliveryCount = ((DeliveryCountUpdateEncoding)encoding).count;
                    break;
                }
                case 35: {
                    if (recordInfo.isUpdate) {
                        PageUpdateTXEncoding pageUpdate = new PageUpdateTXEncoding();
                        pageUpdate.decode(buff);
                        PageTransactionInfo pageTX = pagingManager.getTransaction(pageUpdate.pageTX);
                        pageTX.onUpdate(pageUpdate.recods, null, null);
                        break;
                    }
                    PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
                    pageTransactionInfo.decode(buff);
                    pageTransactionInfo.setRecordID(recordInfo.id);
                    pagingManager.addTransaction(pageTransactionInfo);
                    break;
                }
                case 36: {
                    long messageID = recordInfo.id;
                    EncodingSupport encoding = new ScheduledDeliveryEncoding();
                    ((ScheduledDeliveryEncoding)encoding).decode(buff);
                    LinkedHashMap<Long, AddMessageRecord> queueMessages = (Map)queueMap.get(((ScheduledDeliveryEncoding)encoding).queueID);
                    if (queueMessages == null) {
                        throw new IllegalStateException("Cannot find queue messages " + ((ScheduledDeliveryEncoding)encoding).queueID);
                    }
                    AddMessageRecord rec = (AddMessageRecord)queueMessages.get(messageID);
                    if (rec == null) {
                        throw new IllegalStateException("Cannot find message " + messageID);
                    }
                    rec.scheduledDeliveryTime = ((ScheduledDeliveryEncoding)encoding).scheduledDeliveryTime;
                    break;
                }
                case 37: {
                    DuplicateIDEncoding encoding = new DuplicateIDEncoding();
                    encoding.decode(buff);
                    List<Pair<byte[], Long>> ids = duplicateIDMap.get(encoding.address);
                    if (ids == null) {
                        ids = new ArrayList<Pair<byte[], Long>>();
                        duplicateIDMap.put(encoding.address, ids);
                    }
                    ids.add(new Pair<byte[], Long>(encoding.duplID, recordInfo.id));
                    break;
                }
                case 38: {
                    HeuristicCompletionEncoding encoding = new HeuristicCompletionEncoding();
                    encoding.decode(buff);
                    resourceManager.putHeuristicCompletion(recordInfo.id, encoding.xid, encoding.isCommit);
                    break;
                }
                case 39: {
                    CursorAckRecordEncoding encoding = new CursorAckRecordEncoding();
                    encoding.decode(buff);
                    encoding.position.setRecordID(recordInfo.id);
                    PageSubscription sub = this.locateSubscription(encoding.queueID, pageSubscriptions, queueInfos, pagingManager);
                    if (sub != null) {
                        sub.reloadACK(encoding.position);
                        break;
                    }
                    log.warn("Can't find queue " + encoding.queueID + " while reloading ACKNOWLEDGE_CURSOR");
                    break;
                }
                case 40: {
                    PageCountRecord encoding = new PageCountRecord();
                    encoding.decode(buff);
                    PageSubscription sub = this.locateSubscription(encoding.queueID, pageSubscriptions, queueInfos, pagingManager);
                    if (sub != null) {
                        sub.getCounter().loadValue(recordInfo.id, encoding.value);
                        break;
                    }
                    log.warn("Can't find queue " + encoding.queueID + " while reloading ACKNOWLEDGE_CURSOR");
                    break;
                }
                case 41: {
                    PageCountRecordInc encoding = new PageCountRecordInc();
                    encoding.decode(buff);
                    PageSubscription sub = this.locateSubscription(encoding.queueID, pageSubscriptions, queueInfos, pagingManager);
                    if (sub != null) {
                        sub.getCounter().loadInc(recordInfo.id, encoding.value);
                        break;
                    }
                    log.warn("Can't find queue " + encoding.queueID + " while reloading ACKNOWLEDGE_CURSOR");
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid record type " + recordType);
                }
            }
            records.set(reccount, null);
        }
        records.clear();
        records = null;
        for (Map.Entry entry : queueMap.entrySet()) {
            long queueID = (Long)entry.getKey();
            Map queueRecords = (Map)entry.getValue();
            Queue queue = queues.get(queueID);
            if (queue == null) {
                log.warn("Message for queue " + queueID + " which does not exist. This message will be ignored.");
                continue;
            }
            Collection valueRecords = queueRecords.values();
            for (AddMessageRecord record : valueRecords) {
                long scheduledDeliveryTime = record.scheduledDeliveryTime;
                if (scheduledDeliveryTime != 0L) {
                    record.message.putLongProperty(Message.HDR_SCHEDULED_DELIVERY_TIME, scheduledDeliveryTime);
                }
                MessageReference ref = postOffice.reroute(record.message, queue, null);
                ref.setDeliveryCount(record.deliveryCount);
                if (scheduledDeliveryTime == 0L) continue;
                record.message.removeProperty(Message.HDR_SCHEDULED_DELIVERY_TIME);
            }
        }
        this.loadPreparedTransactions(postOffice, pagingManager, resourceManager, queues, queueInfos, preparedTransactions, duplicateIDMap, pageSubscriptions);
        for (PageSubscription pageSubscription : pageSubscriptions.values()) {
            pageSubscription.getCounter().processReload();
        }
        for (LargeServerMessage largeServerMessage : largeMessages) {
            if (largeServerMessage.getRefCount() != 0) continue;
            log.debug("Large message: " + largeServerMessage.getMessageID() + " didn't have any associated reference, file will be deleted");
            largeServerMessage.decrementDelayDeletionCount();
        }
        for (ServerMessage serverMessage : messages.values()) {
            if (serverMessage.getRefCount() != 0) continue;
            log.info("Deleting unreferenced message id=" + serverMessage.getMessageID() + " from the journal");
            try {
                this.deleteMessage(serverMessage.getMessageID());
            }
            catch (Exception ignored) {
                log.warn("It wasn't possible to delete message " + serverMessage.getMessageID());
            }
        }
        if (pagingManager != null) {
            pagingManager.processReload();
        }
        if (this.perfBlastPages != -1) {
            this.messageJournal.perfBlast(this.perfBlastPages);
        }
        if (System.getProperty("org.hornetq.opt.directblast") != null) {
            this.messageJournal.runDirectJournalBlast();
        }
        this.journalLoaded = true;
        return info;
    }

    private PageSubscription locateSubscription(long queueID, Map<Long, PageSubscription> pageSubscriptions, Map<Long, QueueBindingInfo> queueInfos, PagingManager pagingManager) throws Exception {
        QueueBindingInfo queueInfo;
        PageSubscription subs = pageSubscriptions.get(queueID);
        if (subs == null && (queueInfo = queueInfos.get(queueID)) != null) {
            SimpleString address = queueInfo.getAddress();
            PagingStore store = pagingManager.getPageStore(address);
            subs = store.getCursorProvier().getSubscription(queueID);
            pageSubscriptions.put(queueID, subs);
        }
        return subs;
    }

    @Override
    public void addGrouping(GroupBinding groupBinding) throws Exception {
        GroupingEncoding groupingEncoding = new GroupingEncoding(groupBinding.getId(), groupBinding.getGroupId(), groupBinding.getClusterName());
        this.bindingsJournal.appendAddRecord(groupBinding.getId(), (byte)41, groupingEncoding, true);
    }

    @Override
    public void deleteGrouping(GroupBinding groupBinding) throws Exception {
        this.bindingsJournal.appendDeleteRecord(groupBinding.getId(), true);
    }

    @Override
    public void addQueueBinding(Binding binding) throws Exception {
        Queue queue = (Queue)binding.getBindable();
        Filter filter = queue.getFilter();
        SimpleString filterString = filter == null ? null : filter.getFilterString();
        PersistentQueueBindingEncoding bindingEncoding = new PersistentQueueBindingEncoding(queue.getName(), binding.getAddress(), filterString);
        this.bindingsJournal.appendAddRecord(binding.getID(), (byte)21, bindingEncoding, true);
    }

    @Override
    public void deleteQueueBinding(long queueBindingID) throws Exception {
        this.bindingsJournal.appendDeleteRecord(queueBindingID, true);
    }

    @Override
    public long storePageCounterInc(long txID, long queueID, int value) throws Exception {
        long recordID = this.idGenerator.generateID();
        this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)41, new PageCountRecordInc(queueID, value));
        return recordID;
    }

    @Override
    public long storePageCounterInc(long queueID, int value) throws Exception {
        long recordID = this.idGenerator.generateID();
        this.messageJournal.appendAddRecord(recordID, (byte)41, new PageCountRecordInc(queueID, value), true, (IOCompletion)this.getContext());
        return recordID;
    }

    @Override
    public long storePageCounter(long txID, long queueID, long value) throws Exception {
        long recordID = this.idGenerator.generateID();
        this.messageJournal.appendAddRecordTransactional(txID, recordID, (byte)40, new PageCountRecord(queueID, value));
        return recordID;
    }

    @Override
    public void deleteIncrementRecord(long txID, long recordID) throws Exception {
        this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
    }

    @Override
    public void deletePageCounter(long txID, long recordID) throws Exception {
        this.messageJournal.appendDeleteRecordTransactional(txID, recordID);
    }

    @Override
    public JournalLoadInformation loadBindingJournal(List<QueueBindingInfo> queueBindingInfos, List<GroupingInfo> groupingInfos) throws Exception {
        ArrayList<RecordInfo> records = new ArrayList<RecordInfo>();
        ArrayList<PreparedTransactionInfo> preparedTransactions = new ArrayList<PreparedTransactionInfo>();
        JournalLoadInformation bindingsInfo = this.bindingsJournal.load(records, preparedTransactions, null);
        for (RecordInfo record : records) {
            long id = record.id;
            HornetQBuffer buffer = HornetQBuffers.wrappedBuffer(record.data);
            byte rec = record.getUserRecordType();
            if (rec == 21) {
                PersistentQueueBindingEncoding bindingEncoding = new PersistentQueueBindingEncoding();
                bindingEncoding.decode(buffer);
                bindingEncoding.setId(id);
                queueBindingInfos.add(bindingEncoding);
                continue;
            }
            if (rec == 24) {
                this.idGenerator.loadState(record.id, buffer);
                continue;
            }
            if (rec == 41) {
                GroupingEncoding encoding = new GroupingEncoding();
                encoding.decode(buffer);
                encoding.setId(id);
                groupingInfos.add(encoding);
                continue;
            }
            if (rec == 25) {
                PersistedAddressSetting setting = new PersistedAddressSetting();
                setting.decode(buffer);
                setting.setStoreId(id);
                this.mapPersistedAddressSettings.put(setting.getAddressMatch(), setting);
                continue;
            }
            if (rec == 26) {
                PersistedRoles roles = new PersistedRoles();
                roles.decode(buffer);
                roles.setStoreId(id);
                this.mapPersistedRoles.put(roles.getAddressMatch(), roles);
                continue;
            }
            throw new IllegalStateException("Invalid record type " + rec);
        }
        return bindingsInfo;
    }

    @Override
    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.checkAndCreateDir(this.bindingsDir, this.createBindingsDir);
        this.checkAndCreateDir(this.journalDir, this.createJournalDir);
        this.checkAndCreateDir(this.largeMessagesDirectory, this.createJournalDir);
        this.cleanupIncompleteFiles();
        this.bindingsJournal.start();
        this.messageJournal.start();
        this.started = true;
    }

    @Override
    public synchronized void stop() throws Exception {
        if (!this.started) {
            return;
        }
        if (this.journalLoaded && this.idGenerator != null) {
            this.idGenerator.close();
        }
        this.bindingsJournal.stop();
        this.messageJournal.stop();
        this.journalLoaded = false;
        this.started = false;
    }

    @Override
    public synchronized boolean isStarted() {
        return this.started;
    }

    @Override
    public JournalLoadInformation[] loadInternalOnly() throws Exception {
        JournalLoadInformation[] info = new JournalLoadInformation[]{this.bindingsJournal.loadInternalOnly(), this.messageJournal.loadInternalOnly()};
        return info;
    }

    public Journal getMessageJournal() {
        return this.messageJournal;
    }

    public Journal getBindingsJournal() {
        return this.bindingsJournal;
    }

    void deleteFile(final SequentialFile file) {
        Runnable deleteAction = new Runnable(){

            @Override
            public void run() {
                try {
                    file.delete();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), e);
                }
            }
        };
        if (this.executor == null) {
            deleteAction.run();
        } else {
            this.executor.execute(deleteAction);
        }
    }

    SequentialFile createFileForLargeMessage(long messageID, boolean durable) {
        if (durable) {
            return this.largeMessagesFactory.createSequentialFile(messageID + ".msg", -1);
        }
        return this.largeMessagesFactory.createSequentialFile(messageID + ".tmp", -1);
    }

    private void checkAndCreateDir(String dir, boolean create) {
        File f = new File(dir);
        if (!f.exists()) {
            if (create) {
                if (!f.mkdirs()) {
                    throw new IllegalStateException("Failed to create directory " + dir);
                }
            } else {
                throw new IllegalArgumentException("Directory " + dir + " does not exist and will not create it");
            }
        }
    }

    private LargeServerMessage parseLargeMessage(Map<Long, ServerMessage> messages, HornetQBuffer buff) throws Exception {
        LargeServerMessage largeMessage = this.createLargeMessage();
        LargeMessageEncoding messageEncoding = new LargeMessageEncoding(largeMessage);
        messageEncoding.decode(buff);
        if (largeMessage.containsProperty(Message.HDR_ORIG_MESSAGE_ID)) {
            long originalMessageID = largeMessage.getLongProperty(Message.HDR_ORIG_MESSAGE_ID);
            LargeServerMessage originalMessage = (LargeServerMessage)messages.get(originalMessageID);
            if (originalMessage == null) {
                originalMessage = this.createLargeMessage();
                originalMessage.setDurable(true);
                originalMessage.setMessageID(originalMessageID);
                messages.put(originalMessageID, originalMessage);
            }
            originalMessage.incrementDelayDeletionCount();
            largeMessage.setLinkedMessage(originalMessage);
        }
        return largeMessage;
    }

    private void loadPreparedTransactions(PostOffice postOffice, PagingManager pagingManager, ResourceManager resourceManager, Map<Long, Queue> queues, Map<Long, QueueBindingInfo> queueInfos, List<PreparedTransactionInfo> preparedTransactions, Map<SimpleString, List<Pair<byte[], Long>>> duplicateIDMap, Map<Long, PageSubscription> pageSubscriptions) throws Exception {
        for (PreparedTransactionInfo preparedTransaction : preparedTransactions) {
            HornetQBuffer buff;
            byte[] data;
            XidEncoding encodingXid = new XidEncoding(preparedTransaction.extraData);
            Xid xid = encodingXid.xid;
            TransactionImpl tx = new TransactionImpl(preparedTransaction.id, xid, this);
            ArrayList<MessageReference> referencesToAck = new ArrayList<MessageReference>();
            HashMap<Long, ServerMessage> messages = new HashMap<Long, ServerMessage>();
            block13: for (RecordInfo record : preparedTransaction.records) {
                data = record.data;
                buff = HornetQBuffers.wrappedBuffer(data);
                byte recordType = record.getUserRecordType();
                switch (recordType) {
                    case 30: {
                        messages.put(record.id, this.parseLargeMessage(messages, buff));
                        continue block13;
                    }
                    case 31: {
                        ServerMessageImpl message = new ServerMessageImpl(record.id, 50);
                        message.decode(buff);
                        messages.put(record.id, message);
                        continue block13;
                    }
                    case 32: {
                        long messageID = record.id;
                        RefEncoding encoding = new RefEncoding();
                        encoding.decode(buff);
                        Queue queue = queues.get(encoding.queueID);
                        if (queue == null) {
                            log.warn("Message in prepared tx for queue " + encoding.queueID + " which does not exist. This message will be ignored.");
                            continue block13;
                        }
                        ServerMessage message = (ServerMessage)messages.get(messageID);
                        if (message == null) {
                            throw new IllegalStateException("Cannot find message with id " + messageID);
                        }
                        postOffice.reroute(message, queue, tx);
                        continue block13;
                    }
                    case 33: {
                        long messageID = record.id;
                        RefEncoding encoding = new RefEncoding();
                        encoding.decode(buff);
                        Queue queue = queues.get(encoding.queueID);
                        if (queue == null) {
                            throw new IllegalStateException("Cannot find queue with id " + encoding.queueID);
                        }
                        MessageReference removed = queue.removeReferenceWithID(messageID);
                        referencesToAck.add(removed);
                        if (removed != null) continue block13;
                        throw new IllegalStateException("Failed to remove reference for " + messageID);
                    }
                    case 35: {
                        PageTransactionInfoImpl pageTransactionInfo = new PageTransactionInfoImpl();
                        pageTransactionInfo.decode(buff);
                        tx.putProperty(5, pageTransactionInfo);
                        pagingManager.addTransaction(pageTransactionInfo);
                        tx.addOperation(new FinishPageMessageOperation());
                        continue block13;
                    }
                    case 36: {
                        continue block13;
                    }
                    case 37: {
                        EncodingSupport encoding = new DuplicateIDEncoding();
                        ((DuplicateIDEncoding)encoding).decode(buff);
                        List<Pair<byte[], Long>> ids = duplicateIDMap.get(((DuplicateIDEncoding)encoding).address);
                        if (ids == null) {
                            ids = new ArrayList<Pair<byte[], Long>>();
                            duplicateIDMap.put(((DuplicateIDEncoding)encoding).address, ids);
                        }
                        ids.add(new Pair<byte[], Long>(((DuplicateIDEncoding)encoding).duplID, record.id));
                        continue block13;
                    }
                    case 39: {
                        EncodingSupport encoding = new CursorAckRecordEncoding();
                        ((CursorAckRecordEncoding)encoding).decode(buff);
                        ((CursorAckRecordEncoding)encoding).position.setRecordID(record.id);
                        PageSubscription sub = this.locateSubscription(((CursorAckRecordEncoding)encoding).queueID, pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.reloadPreparedACK(tx, ((CursorAckRecordEncoding)encoding).position);
                            continue block13;
                        }
                        log.warn("Can't find queue " + ((CursorAckRecordEncoding)encoding).queueID + " while reloading ACKNOWLEDGE_CURSOR");
                        continue block13;
                    }
                    case 40: {
                        log.warn("PAGE_CURSOR_COUNTER_VALUE record used on a prepared statement, what shouldn't happen");
                        continue block13;
                    }
                    case 41: {
                        EncodingSupport encoding = new PageCountRecordInc();
                        ((PageCountRecordInc)encoding).decode(buff);
                        PageSubscription sub = this.locateSubscription(((PageCountRecordInc)encoding).queueID, pageSubscriptions, queueInfos, pagingManager);
                        if (sub != null) {
                            sub.getCounter().applyIncrement(tx, record.id, ((PageCountRecordInc)encoding).value);
                            continue block13;
                        }
                        log.warn("Can't find queue " + ((PageCountRecordInc)encoding).queueID + " while reloading ACKNOWLEDGE_CURSOR");
                        continue block13;
                    }
                }
                log.warn("InternalError: Record type " + recordType + " not recognized. Maybe you're using journal files created on a different version");
            }
            for (RecordInfo record : preparedTransaction.recordsToDelete) {
                data = record.data;
                buff = HornetQBuffers.wrappedBuffer(data);
                long messageID = record.id;
                DeleteEncoding encoding = new DeleteEncoding();
                encoding.decode(buff);
                Queue queue = queues.get(encoding.queueID);
                if (queue == null) {
                    throw new IllegalStateException("Cannot find queue with id " + encoding.queueID);
                }
                MessageReference removed = queue.removeReferenceWithID(messageID);
                if (removed == null) continue;
                referencesToAck.add(removed);
            }
            for (MessageReference ack : referencesToAck) {
                ack.getQueue().reacknowledge(tx, ack);
            }
            tx.setState(Transaction.State.PREPARED);
            resourceManager.putTransaction(xid, tx);
        }
    }

    private void cleanupIncompleteFiles() throws Exception {
        if (this.largeMessagesFactory != null) {
            List<String> tmpFiles = this.largeMessagesFactory.listFiles("tmp");
            for (String tmpFile : tmpFiles) {
                SequentialFile file = this.largeMessagesFactory.createSequentialFile(tmpFile, -1);
                file.delete();
            }
        }
    }

    private OperationContext getContext(boolean sync) {
        if (sync) {
            return this.getContext();
        }
        return DummyOperationContext.getInstance();
    }

    private class LargeMessageTXFailureCallback
    implements TransactionFailureCallback {
        private final Map<Long, ServerMessage> messages;

        public LargeMessageTXFailureCallback(Map<Long, ServerMessage> messages) {
            this.messages = messages;
        }

        @Override
        public void failedTransaction(long transactionID, List<RecordInfo> records, List<RecordInfo> recordsToDelete) {
            for (RecordInfo record : records) {
                if (record.userRecordType != 30) continue;
                byte[] data = record.data;
                HornetQBuffer buff = HornetQBuffers.wrappedBuffer(data);
                try {
                    LargeServerMessage serverMessage = JournalStorageManager.this.parseLargeMessage(this.messages, buff);
                    serverMessage.decrementDelayDeletionCount();
                }
                catch (Exception e) {
                    log.warn(e.getMessage(), e);
                }
            }
        }
    }

    private static final class CursorAckRecordEncoding
    implements EncodingSupport {
        long queueID;
        PagePosition position;

        public CursorAckRecordEncoding(long queueID, PagePosition position) {
            this.queueID = queueID;
            this.position = position;
        }

        public CursorAckRecordEncoding() {
            this.position = new PagePositionImpl();
        }

        @Override
        public int getEncodeSize() {
            return 20;
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.queueID);
            buffer.writeLong(this.position.getPageNr());
            buffer.writeInt(this.position.getMessageNr());
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            this.queueID = buffer.readLong();
            long pageNR = buffer.readLong();
            int messageNR = buffer.readInt();
            this.position = new PagePositionImpl(pageNR, messageNR);
        }
    }

    private static final class AddMessageRecord {
        final ServerMessage message;
        long scheduledDeliveryTime;
        int deliveryCount;

        public AddMessageRecord(ServerMessage message) {
            this.message = message;
        }
    }

    private static final class PageCountRecordInc
    implements EncodingSupport {
        long queueID;
        int value;

        PageCountRecordInc() {
        }

        PageCountRecordInc(long queueID, int value) {
            this.queueID = queueID;
            this.value = value;
        }

        @Override
        public int getEncodeSize() {
            return 12;
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.queueID);
            buffer.writeInt(this.value);
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            this.queueID = buffer.readLong();
            this.value = buffer.readInt();
        }
    }

    private static final class PageCountRecord
    implements EncodingSupport {
        long queueID;
        long value;

        PageCountRecord() {
        }

        PageCountRecord(long queueID, long value) {
            this.queueID = queueID;
            this.value = value;
        }

        @Override
        public int getEncodeSize() {
            return 16;
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.queueID);
            buffer.writeLong(this.value);
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            this.queueID = buffer.readLong();
            this.value = buffer.readLong();
        }
    }

    private class FinishPageMessageOperation
    implements TransactionOperation {
        private FinishPageMessageOperation() {
        }

        @Override
        public void afterCommit(Transaction tx) {
            PageTransactionInfo pageTransaction = (PageTransactionInfo)tx.getProperty(5);
            if (pageTransaction != null) {
                pageTransaction.commit();
            }
        }

        @Override
        public void afterPrepare(Transaction tx) {
        }

        @Override
        public void afterRollback(Transaction tx) {
            PageTransactionInfo pageTransaction = (PageTransactionInfo)tx.getProperty(5);
            if (tx.getState() == Transaction.State.PREPARED && pageTransaction != null) {
                pageTransaction.rollback();
            }
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return null;
        }
    }

    private static class DuplicateIDEncoding
    implements EncodingSupport {
        SimpleString address;
        byte[] duplID;

        public DuplicateIDEncoding(SimpleString address, byte[] duplID) {
            this.address = address;
            this.duplID = duplID;
        }

        public DuplicateIDEncoding() {
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            this.address = buffer.readSimpleString();
            int size = buffer.readInt();
            this.duplID = new byte[size];
            buffer.readBytes(this.duplID);
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            buffer.writeSimpleString(this.address);
            buffer.writeInt(this.duplID.length);
            buffer.writeBytes(this.duplID);
        }

        @Override
        public int getEncodeSize() {
            return SimpleString.sizeofString(this.address) + 4 + this.duplID.length;
        }
    }

    private static class ScheduledDeliveryEncoding
    extends QueueEncoding {
        long scheduledDeliveryTime;

        private ScheduledDeliveryEncoding(long scheduledDeliveryTime, long queueID) {
            super(queueID);
            this.scheduledDeliveryTime = scheduledDeliveryTime;
        }

        public ScheduledDeliveryEncoding() {
        }

        @Override
        public int getEncodeSize() {
            return super.getEncodeSize() + 8;
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            super.encode(buffer);
            buffer.writeLong(this.scheduledDeliveryTime);
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            super.decode(buffer);
            this.scheduledDeliveryTime = buffer.readLong();
        }
    }

    private static class PageUpdateTXEncoding
    implements EncodingSupport {
        public long pageTX;
        public int recods;

        public PageUpdateTXEncoding() {
        }

        public PageUpdateTXEncoding(long pageTX, int records) {
            this.pageTX = pageTX;
            this.recods = records;
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            this.pageTX = buffer.readLong();
            this.recods = buffer.readInt();
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.pageTX);
            buffer.writeInt(this.recods);
        }

        @Override
        public int getEncodeSize() {
            return 12;
        }

        public List<MessageReference> getRelatedMessageReferences() {
            return null;
        }
    }

    private static class RefEncoding
    extends QueueEncoding {
        public RefEncoding() {
        }

        public RefEncoding(long queueID) {
            super(queueID);
        }
    }

    private static class DeleteEncoding
    extends QueueEncoding {
        public DeleteEncoding() {
        }

        public DeleteEncoding(long queueID) {
            super(queueID);
        }
    }

    private static class QueueEncoding
    implements EncodingSupport {
        long queueID;

        public QueueEncoding(long queueID) {
            this.queueID = queueID;
        }

        public QueueEncoding() {
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            this.queueID = buffer.readLong();
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.queueID);
        }

        @Override
        public int getEncodeSize() {
            return 8;
        }
    }

    private static class DeliveryCountUpdateEncoding
    implements EncodingSupport {
        long queueID;
        int count;

        public DeliveryCountUpdateEncoding() {
        }

        public DeliveryCountUpdateEncoding(long queueID, int count) {
            this.queueID = queueID;
            this.count = count;
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            this.queueID = buffer.readLong();
            this.count = buffer.readInt();
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            buffer.writeLong(this.queueID);
            buffer.writeInt(this.count);
        }

        @Override
        public int getEncodeSize() {
            return 12;
        }
    }

    private static class LargeMessageEncoding
    implements EncodingSupport {
        private final LargeServerMessage message;

        public LargeMessageEncoding(LargeServerMessage message) {
            this.message = message;
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            this.message.decodeHeadersAndProperties(buffer);
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            this.message.encode(buffer);
        }

        @Override
        public int getEncodeSize() {
            return this.message.getEncodeSize();
        }
    }

    private static class PersistentIDEncoding
    implements EncodingSupport {
        UUID uuid;

        PersistentIDEncoding(UUID uuid) {
            this.uuid = uuid;
        }

        PersistentIDEncoding() {
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            byte[] bytes = new byte[16];
            buffer.readBytes(bytes);
            this.uuid = new UUID(1, bytes);
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            buffer.writeBytes(this.uuid.asBytes());
        }

        @Override
        public int getEncodeSize() {
            return 16;
        }
    }

    private static class PersistentQueueBindingEncoding
    implements EncodingSupport,
    QueueBindingInfo {
        long id;
        SimpleString name;
        SimpleString address;
        SimpleString filterString;

        public PersistentQueueBindingEncoding() {
        }

        public PersistentQueueBindingEncoding(SimpleString name, SimpleString address, SimpleString filterString) {
            this.name = name;
            this.address = address;
            this.filterString = filterString;
        }

        @Override
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @Override
        public SimpleString getAddress() {
            return this.address;
        }

        @Override
        public SimpleString getFilterString() {
            return this.filterString;
        }

        @Override
        public SimpleString getQueueName() {
            return this.name;
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            this.name = buffer.readSimpleString();
            this.address = buffer.readSimpleString();
            this.filterString = buffer.readNullableSimpleString();
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            buffer.writeSimpleString(this.name);
            buffer.writeSimpleString(this.address);
            buffer.writeNullableSimpleString(this.filterString);
        }

        @Override
        public int getEncodeSize() {
            return SimpleString.sizeofString(this.name) + SimpleString.sizeofString(this.address) + SimpleString.sizeofNullableString(this.filterString);
        }
    }

    private static class GroupingEncoding
    implements EncodingSupport,
    GroupingInfo {
        long id;
        SimpleString groupId;
        SimpleString clusterName;

        public GroupingEncoding(long id, SimpleString groupId, SimpleString clusterName) {
            this.id = id;
            this.groupId = groupId;
            this.clusterName = clusterName;
        }

        public GroupingEncoding() {
        }

        @Override
        public int getEncodeSize() {
            return SimpleString.sizeofString(this.groupId) + SimpleString.sizeofString(this.clusterName);
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            buffer.writeSimpleString(this.groupId);
            buffer.writeSimpleString(this.clusterName);
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            this.groupId = buffer.readSimpleString();
            this.clusterName = buffer.readSimpleString();
        }

        @Override
        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        @Override
        public SimpleString getGroupId() {
            return this.groupId;
        }

        @Override
        public SimpleString getClusterName() {
            return this.clusterName;
        }

        public String toString() {
            return this.id + ":" + this.groupId + ":" + this.clusterName;
        }
    }

    private static class HeuristicCompletionEncoding
    implements EncodingSupport {
        Xid xid;
        boolean isCommit;

        HeuristicCompletionEncoding(Xid xid, boolean isCommit) {
            this.xid = xid;
            this.isCommit = isCommit;
        }

        HeuristicCompletionEncoding() {
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            this.xid = XidCodecSupport.decodeXid(buffer);
            this.isCommit = buffer.readBoolean();
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            XidCodecSupport.encodeXid(this.xid, buffer);
            buffer.writeBoolean(this.isCommit);
        }

        @Override
        public int getEncodeSize() {
            return XidCodecSupport.getXidEncodeLength(this.xid) + 1;
        }
    }

    private static class XidEncoding
    implements EncodingSupport {
        final Xid xid;

        XidEncoding(Xid xid) {
            this.xid = xid;
        }

        XidEncoding(byte[] data) {
            this.xid = XidCodecSupport.decodeXid(HornetQBuffers.wrappedBuffer(data));
        }

        @Override
        public void decode(HornetQBuffer buffer) {
            throw new IllegalStateException("Non Supported Operation");
        }

        @Override
        public void encode(HornetQBuffer buffer) {
            XidCodecSupport.encodeXid(this.xid, buffer);
        }

        @Override
        public int getEncodeSize() {
            return XidCodecSupport.getXidEncodeLength(this.xid);
        }
    }

    static class DummyOperationContext
    implements OperationContext {
        private static DummyOperationContext instance = new DummyOperationContext();

        DummyOperationContext() {
        }

        public static OperationContext getInstance() {
            return instance;
        }

        public void complete() {
        }

        @Override
        public void executeOnCompletion(IOAsyncTask runnable) {
            runnable.done();
        }

        @Override
        public void replicationDone() {
        }

        @Override
        public void replicationLineUp() {
        }

        @Override
        public void storeLineUp() {
        }

        @Override
        public void done() {
        }

        @Override
        public void onError(int errorCode, String errorMessage) {
        }

        @Override
        public void waitCompletion() {
        }

        @Override
        public boolean waitCompletion(long timeout) {
            return true;
        }

        @Override
        public void pageSyncLineUp() {
        }

        @Override
        public void pageSyncDone() {
        }
    }
}

