/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.api.core.TransportConfiguration;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class NodeAnnounceMessage
extends PacketImpl {
    private static final Logger log = Logger.getLogger(NodeAnnounceMessage.class);
    private String nodeID;
    private boolean backup;
    private TransportConfiguration connector;

    public NodeAnnounceMessage(String nodeID, boolean backup, TransportConfiguration tc) {
        super((byte)111);
        this.nodeID = nodeID;
        this.backup = backup;
        this.connector = tc;
    }

    public NodeAnnounceMessage() {
        super((byte)111);
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public boolean isBackup() {
        return this.backup;
    }

    public TransportConfiguration getConnector() {
        return this.connector;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeString(this.nodeID);
        buffer.writeBoolean(this.backup);
        this.connector.encode(buffer);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.nodeID = buffer.readString();
        this.backup = buffer.readBoolean();
        this.connector = new TransportConfiguration();
        this.connector.decode(buffer);
    }
}

