/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.stomp;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hornetq.api.core.Message;
import org.hornetq.api.core.SimpleString;
import org.hornetq.core.client.impl.ClientMessageImpl;
import org.hornetq.core.logging.Logger;
import org.hornetq.core.message.impl.MessageInternal;
import org.hornetq.core.protocol.stomp.Stomp;
import org.hornetq.core.protocol.stomp.StompFrame;
import org.hornetq.core.server.impl.ServerMessageImpl;

class StompUtils {
    private static final Logger log = Logger.getLogger(StompUtils.class);

    StompUtils() {
    }

    public static void copyStandardHeadersFromFrameToMessage(StompFrame frame, ServerMessageImpl msg) throws Exception {
        String expiration;
        Object replyTo;
        String persistent;
        HashMap<String, Object> headers = new HashMap<String, Object>(frame.getHeaders());
        String priority = (String)headers.remove("priority");
        if (priority != null) {
            msg.setPriority(Byte.parseByte(priority));
        }
        if ((persistent = (String)headers.remove(Stomp.Headers.Send.PERSISTENT)) != null) {
            msg.setDurable(Boolean.parseBoolean(persistent));
        }
        msg.putObjectProperty("JMSCorrelationID", headers.remove("correlation-id"));
        msg.putObjectProperty("JMSType", headers.remove("type"));
        String groupID = (String)headers.remove("JMSXGroupID");
        if (groupID != null) {
            msg.putStringProperty(Message.HDR_GROUP_ID, SimpleString.toSimpleString(groupID));
        }
        if ((replyTo = headers.remove("reply-to")) != null) {
            msg.putStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME, SimpleString.toSimpleString((String)replyTo));
        }
        if ((expiration = (String)headers.remove("expires")) != null) {
            msg.setExpiration(Long.parseLong(expiration));
        }
        for (Map.Entry entry : headers.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            msg.putObjectProperty(name, value);
        }
    }

    public static void copyStandardHeadersFromMessageToFrame(MessageInternal message, StompFrame command, int deliveryCount) throws Exception {
        Map<String, Object> headers = command.getHeaders();
        headers.put("destination", message.getAddress().toString());
        headers.put("message-id", message.getMessageID());
        if (message.getObjectProperty("JMSCorrelationID") != null) {
            headers.put("correlation-id", message.getObjectProperty("JMSCorrelationID"));
        }
        headers.put("expires", "" + message.getExpiration());
        headers.put("redelivered", deliveryCount > 1);
        headers.put("priority", "" + message.getPriority());
        if (message.getStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME) != null) {
            headers.put("reply-to", message.getStringProperty(ClientMessageImpl.REPLYTO_HEADER_NAME));
        }
        headers.put("timestamp", "" + message.getTimestamp());
        if (message.getObjectProperty("JMSType") != null) {
            headers.put("type", message.getObjectProperty("JMSType"));
        }
        Set<SimpleString> names = message.getPropertyNames();
        for (SimpleString name : names) {
            if (name.equals(ClientMessageImpl.REPLYTO_HEADER_NAME) || name.toString().equals("JMSType") || name.toString().equals("JMSCorrelationID")) continue;
            headers.put(name.toString(), message.getObjectProperty(name));
        }
    }
}

